/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.models.ClearRange;
import com.azure.storage.file.share.models.FileRange;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareFileRangeList
implements XmlSerializable<ShareFileRangeList> {
    private List<FileRange> ranges = new ArrayList<FileRange>();
    private List<ClearRange> clearRanges = new ArrayList<ClearRange>();

    public List<FileRange> getRanges() {
        return this.ranges;
    }

    public ShareFileRangeList setRanges(List<FileRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public List<ClearRange> getClearRanges() {
        return this.clearRanges;
    }

    public ShareFileRangeList setClearRanges(List<ClearRange> clearRanges) {
        this.clearRanges = clearRanges;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Ranges" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.ranges != null) {
            for (FileRange fileRange : this.ranges) {
                xmlWriter.writeXml((XmlSerializable)fileRange, "Range");
            }
        }
        if (this.clearRanges != null) {
            for (ClearRange clearRange : this.clearRanges) {
                xmlWriter.writeXml((XmlSerializable)clearRange, "ClearRange");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareFileRangeList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareFileRangeList.fromXml(xmlReader, null);
    }

    public static ShareFileRangeList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Ranges" : rootElementName;
        return (ShareFileRangeList)xmlReader.readObject(finalRootElementName, reader -> {
            ShareFileRangeList deserializedShareFileRangeList = new ShareFileRangeList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Range".equals(elementName.getLocalPart())) {
                    if (deserializedShareFileRangeList.ranges == null) {
                        deserializedShareFileRangeList.ranges = new ArrayList<FileRange>();
                    }
                    deserializedShareFileRangeList.ranges.add(FileRange.fromXml(reader, "Range"));
                    continue;
                }
                if ("ClearRange".equals(elementName.getLocalPart())) {
                    if (deserializedShareFileRangeList.clearRanges == null) {
                        deserializedShareFileRangeList.clearRanges = new ArrayList<ClearRange>();
                    }
                    deserializedShareFileRangeList.clearRanges.add(ClearRange.fromXml(reader, "ClearRange"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareFileRangeList;
        });
    }
}

