// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A listed Azure Storage share item.
 */
@Fluent
public final class ShareItem implements XmlSerializable<ShareItem> {
    /*
     * The name property.
     */
    private String name;

    /*
     * The snapshot property.
     */
    private String snapshot;

    /*
     * The deleted property.
     */
    private Boolean deleted;

    /*
     * The version property.
     */
    private String version;

    /*
     * The properties property.
     */
    private ShareProperties properties;

    /*
     * The metadata property.
     */
    private Map<String, String> metadata;

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     *
     * @param name the name value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the snapshot property: The snapshot property.
     *
     * @return the snapshot value.
     */
    public String getSnapshot() {
        return this.snapshot;
    }

    /**
     * Set the snapshot property: The snapshot property.
     *
     * @param snapshot the snapshot value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    /**
     * Get the deleted property: The deleted property.
     *
     * @return the deleted value.
     */
    public Boolean isDeleted() {
        return this.deleted;
    }

    /**
     * Set the deleted property: The deleted property.
     *
     * @param deleted the deleted value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * Get the version property: The version property.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version property.
     *
     * @param version the version value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the properties property: The properties property.
     *
     * @return the properties value.
     */
    public ShareProperties getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties property.
     *
     * @param properties the properties value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setProperties(ShareProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the metadata property: The metadata property.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The metadata property.
     *
     * @param metadata the metadata value to set.
     * @return the ShareItem object itself.
     */
    public ShareItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareItem from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the ShareItem.
     */
    public static ShareItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareItem from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the ShareItem.
     */
    public static ShareItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareItem deserializedShareItem = new ShareItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedShareItem.name = reader.getStringElement();
                } else if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedShareItem.snapshot = reader.getStringElement();
                } else if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedShareItem.deleted = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("Version".equals(elementName.getLocalPart())) {
                    deserializedShareItem.version = reader.getStringElement();
                } else if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedShareItem.properties = ShareProperties.fromXml(reader, "Properties");
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedShareItem.metadata == null) {
                            deserializedShareItem.metadata = new LinkedHashMap<>();
                        }
                        deserializedShareItem.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareItem;
        });
    }
}
