// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The StorageError model.
 */
@Fluent
public final class StorageError implements XmlSerializable<StorageError> {
    /*
     * The Message property.
     */
    private String message;

    /*
     * The CopySourceStatusCode property.
     */
    private Long copySourceStatusCode;

    /*
     * The CopySourceErrorCode property.
     */
    private String copySourceErrorCode;

    /*
     * The CopySourceErrorMessage property.
     */
    private String copySourceErrorMessage;

    /*
     * The AuthenticationErrorDetail property.
     */
    private String authenticationErrorDetail;

    /**
     * Creates an instance of StorageError class.
     */
    public StorageError() {
    }

    /**
     * Get the message property: The Message property.
     * 
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: The Message property.
     * 
     * @param message the message value to set.
     * @return the StorageError object itself.
     */
    public StorageError setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the copySourceStatusCode property: The CopySourceStatusCode property.
     * 
     * @return the copySourceStatusCode value.
     */
    public Long getCopySourceStatusCode() {
        return this.copySourceStatusCode;
    }

    /**
     * Set the copySourceStatusCode property: The CopySourceStatusCode property.
     * 
     * @param copySourceStatusCode the copySourceStatusCode value to set.
     * @return the StorageError object itself.
     */
    public StorageError setCopySourceStatusCode(Long copySourceStatusCode) {
        this.copySourceStatusCode = copySourceStatusCode;
        return this;
    }

    /**
     * Get the copySourceErrorCode property: The CopySourceErrorCode property.
     * 
     * @return the copySourceErrorCode value.
     */
    public String getCopySourceErrorCode() {
        return this.copySourceErrorCode;
    }

    /**
     * Set the copySourceErrorCode property: The CopySourceErrorCode property.
     * 
     * @param copySourceErrorCode the copySourceErrorCode value to set.
     * @return the StorageError object itself.
     */
    public StorageError setCopySourceErrorCode(String copySourceErrorCode) {
        this.copySourceErrorCode = copySourceErrorCode;
        return this;
    }

    /**
     * Get the copySourceErrorMessage property: The CopySourceErrorMessage property.
     * 
     * @return the copySourceErrorMessage value.
     */
    public String getCopySourceErrorMessage() {
        return this.copySourceErrorMessage;
    }

    /**
     * Set the copySourceErrorMessage property: The CopySourceErrorMessage property.
     * 
     * @param copySourceErrorMessage the copySourceErrorMessage value to set.
     * @return the StorageError object itself.
     */
    public StorageError setCopySourceErrorMessage(String copySourceErrorMessage) {
        this.copySourceErrorMessage = copySourceErrorMessage;
        return this;
    }

    /**
     * Get the authenticationErrorDetail property: The AuthenticationErrorDetail property.
     * 
     * @return the authenticationErrorDetail value.
     */
    public String getAuthenticationErrorDetail() {
        return this.authenticationErrorDetail;
    }

    /**
     * Set the authenticationErrorDetail property: The AuthenticationErrorDetail property.
     * 
     * @param authenticationErrorDetail the authenticationErrorDetail value to set.
     * @return the StorageError object itself.
     */
    public StorageError setAuthenticationErrorDetail(String authenticationErrorDetail) {
        this.authenticationErrorDetail = authenticationErrorDetail;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "StorageError" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Message", this.message);
        xmlWriter.writeNumberElement("CopySourceStatusCode", this.copySourceStatusCode);
        xmlWriter.writeStringElement("CopySourceErrorCode", this.copySourceErrorCode);
        xmlWriter.writeStringElement("CopySourceErrorMessage", this.copySourceErrorMessage);
        xmlWriter.writeStringElement("AuthenticationErrorDetail", this.authenticationErrorDetail);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of StorageError from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of StorageError if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the StorageError.
     */
    public static StorageError fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of StorageError from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of StorageError if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the StorageError.
     */
    public static StorageError fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "StorageError" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            StorageError deserializedStorageError = new StorageError();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Message".equals(elementName.getLocalPart())) {
                    deserializedStorageError.message = reader.getStringElement();
                } else if ("CopySourceStatusCode".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceStatusCode = reader.getNullableElement(Long::parseLong);
                } else if ("CopySourceErrorCode".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceErrorCode = reader.getStringElement();
                } else if ("CopySourceErrorMessage".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceErrorMessage = reader.getStringElement();
                } else if ("AuthenticationErrorDetail".equals(elementName.getLocalPart())) {
                    deserializedStorageError.authenticationErrorDetail = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedStorageError;
        });
    }
}
