/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class StorageError
implements XmlSerializable<StorageError> {
    private String message;
    private Long copySourceStatusCode;
    private String copySourceErrorCode;
    private String copySourceErrorMessage;
    private String authenticationErrorDetail;

    public String getMessage() {
        return this.message;
    }

    public StorageError setMessage(String message) {
        this.message = message;
        return this;
    }

    public Long getCopySourceStatusCode() {
        return this.copySourceStatusCode;
    }

    public StorageError setCopySourceStatusCode(Long copySourceStatusCode) {
        this.copySourceStatusCode = copySourceStatusCode;
        return this;
    }

    public String getCopySourceErrorCode() {
        return this.copySourceErrorCode;
    }

    public StorageError setCopySourceErrorCode(String copySourceErrorCode) {
        this.copySourceErrorCode = copySourceErrorCode;
        return this;
    }

    public String getCopySourceErrorMessage() {
        return this.copySourceErrorMessage;
    }

    public StorageError setCopySourceErrorMessage(String copySourceErrorMessage) {
        this.copySourceErrorMessage = copySourceErrorMessage;
        return this;
    }

    public String getAuthenticationErrorDetail() {
        return this.authenticationErrorDetail;
    }

    public StorageError setAuthenticationErrorDetail(String authenticationErrorDetail) {
        this.authenticationErrorDetail = authenticationErrorDetail;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageError" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Message", this.message);
        xmlWriter.writeNumberElement("CopySourceStatusCode", (Number)this.copySourceStatusCode);
        xmlWriter.writeStringElement("CopySourceErrorCode", this.copySourceErrorCode);
        xmlWriter.writeStringElement("CopySourceErrorMessage", this.copySourceErrorMessage);
        xmlWriter.writeStringElement("AuthenticationErrorDetail", this.authenticationErrorDetail);
        return xmlWriter.writeEndElement();
    }

    public static StorageError fromXml(XmlReader xmlReader) throws XMLStreamException {
        return StorageError.fromXml(xmlReader, null);
    }

    public static StorageError fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageError" : rootElementName;
        return (StorageError)xmlReader.readObject(finalRootElementName, reader -> {
            StorageError deserializedStorageError = new StorageError();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Message".equals(elementName.getLocalPart())) {
                    deserializedStorageError.message = reader.getStringElement();
                    continue;
                }
                if ("CopySourceStatusCode".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceStatusCode = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("CopySourceErrorCode".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceErrorCode = reader.getStringElement();
                    continue;
                }
                if ("CopySourceErrorMessage".equals(elementName.getLocalPart())) {
                    deserializedStorageError.copySourceErrorMessage = reader.getStringElement();
                    continue;
                }
                if ("AuthenticationErrorDetail".equals(elementName.getLocalPart())) {
                    deserializedStorageError.authenticationErrorDetail = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedStorageError;
        });
    }
}

