// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Properties of a share.
 */
@Fluent
public final class SharePropertiesInternal implements XmlSerializable<SharePropertiesInternal> {
    /*
     * The Last-Modified property.
     */
    private DateTimeRfc1123 lastModified;

    /*
     * The Etag property.
     */
    private String eTag;

    /*
     * The Quota property.
     */
    private int quota;

    /*
     * The ProvisionedIops property.
     */
    private Integer provisionedIops;

    /*
     * The ProvisionedIngressMBps property.
     */
    private Integer provisionedIngressMBps;

    /*
     * The ProvisionedEgressMBps property.
     */
    private Integer provisionedEgressMBps;

    /*
     * The ProvisionedBandwidthMiBps property.
     */
    private Integer provisionedBandwidthMiBps;

    /*
     * The NextAllowedQuotaDowngradeTime property.
     */
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;

    /*
     * The DeletedTime property.
     */
    private DateTimeRfc1123 deletedTime;

    /*
     * The RemainingRetentionDays property.
     */
    private Integer remainingRetentionDays;

    /*
     * The AccessTier property.
     */
    private String accessTier;

    /*
     * The AccessTierChangeTime property.
     */
    private DateTimeRfc1123 accessTierChangeTime;

    /*
     * The AccessTierTransitionState property.
     */
    private String accessTierTransitionState;

    /*
     * The current lease status of the share.
     */
    private LeaseStatusType leaseStatus;

    /*
     * Lease state of the share.
     */
    private LeaseStateType leaseState;

    /*
     * When a share is leased, specifies whether the lease is of infinite or fixed duration.
     */
    private LeaseDurationType leaseDuration;

    /*
     * The EnabledProtocols property.
     */
    private String enabledProtocols;

    /*
     * The RootSquash property.
     */
    private ShareRootSquash rootSquash;

    /*
     * Dictionary of <string>
     */
    private Map<String, String> metadata;

    /**
     * Creates an instance of SharePropertiesInternal class.
     */
    public SharePropertiesInternal() {
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     * 
     * @param lastModified the lastModified value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the eTag property: The Etag property.
     * 
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The Etag property.
     * 
     * @param eTag the eTag value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the quota property: The Quota property.
     * 
     * @return the quota value.
     */
    public int getQuota() {
        return this.quota;
    }

    /**
     * Set the quota property: The Quota property.
     * 
     * @param quota the quota value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Get the provisionedIops property: The ProvisionedIops property.
     * 
     * @return the provisionedIops value.
     */
    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    /**
     * Set the provisionedIops property: The ProvisionedIops property.
     * 
     * @param provisionedIops the provisionedIops value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    /**
     * Get the provisionedIngressMBps property: The ProvisionedIngressMBps property.
     * 
     * @return the provisionedIngressMBps value.
     */
    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    /**
     * Set the provisionedIngressMBps property: The ProvisionedIngressMBps property.
     * 
     * @param provisionedIngressMBps the provisionedIngressMBps value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    /**
     * Get the provisionedEgressMBps property: The ProvisionedEgressMBps property.
     * 
     * @return the provisionedEgressMBps value.
     */
    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    /**
     * Set the provisionedEgressMBps property: The ProvisionedEgressMBps property.
     * 
     * @param provisionedEgressMBps the provisionedEgressMBps value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    /**
     * Get the provisionedBandwidthMiBps property: The ProvisionedBandwidthMiBps property.
     * 
     * @return the provisionedBandwidthMiBps value.
     */
    public Integer getProvisionedBandwidthMiBps() {
        return this.provisionedBandwidthMiBps;
    }

    /**
     * Set the provisionedBandwidthMiBps property: The ProvisionedBandwidthMiBps property.
     * 
     * @param provisionedBandwidthMiBps the provisionedBandwidthMiBps value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setProvisionedBandwidthMiBps(Integer provisionedBandwidthMiBps) {
        this.provisionedBandwidthMiBps = provisionedBandwidthMiBps;
        return this;
    }

    /**
     * Get the nextAllowedQuotaDowngradeTime property: The NextAllowedQuotaDowngradeTime property.
     * 
     * @return the nextAllowedQuotaDowngradeTime value.
     */
    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    /**
     * Set the nextAllowedQuotaDowngradeTime property: The NextAllowedQuotaDowngradeTime property.
     * 
     * @param nextAllowedQuotaDowngradeTime the nextAllowedQuotaDowngradeTime value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        if (nextAllowedQuotaDowngradeTime == null) {
            this.nextAllowedQuotaDowngradeTime = null;
        } else {
            this.nextAllowedQuotaDowngradeTime = new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        }
        return this;
    }

    /**
     * Get the deletedTime property: The DeletedTime property.
     * 
     * @return the deletedTime value.
     */
    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    /**
     * Set the deletedTime property: The DeletedTime property.
     * 
     * @param deletedTime the deletedTime value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        if (deletedTime == null) {
            this.deletedTime = null;
        } else {
            this.deletedTime = new DateTimeRfc1123(deletedTime);
        }
        return this;
    }

    /**
     * Get the remainingRetentionDays property: The RemainingRetentionDays property.
     * 
     * @return the remainingRetentionDays value.
     */
    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Set the remainingRetentionDays property: The RemainingRetentionDays property.
     * 
     * @param remainingRetentionDays the remainingRetentionDays value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    /**
     * Get the accessTier property: The AccessTier property.
     * 
     * @return the accessTier value.
     */
    public String getAccessTier() {
        return this.accessTier;
    }

    /**
     * Set the accessTier property: The AccessTier property.
     * 
     * @param accessTier the accessTier value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    /**
     * Get the accessTierChangeTime property: The AccessTierChangeTime property.
     * 
     * @return the accessTierChangeTime value.
     */
    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    /**
     * Set the accessTierChangeTime property: The AccessTierChangeTime property.
     * 
     * @param accessTierChangeTime the accessTierChangeTime value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        if (accessTierChangeTime == null) {
            this.accessTierChangeTime = null;
        } else {
            this.accessTierChangeTime = new DateTimeRfc1123(accessTierChangeTime);
        }
        return this;
    }

    /**
     * Get the accessTierTransitionState property: The AccessTierTransitionState property.
     * 
     * @return the accessTierTransitionState value.
     */
    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    /**
     * Set the accessTierTransitionState property: The AccessTierTransitionState property.
     * 
     * @param accessTierTransitionState the accessTierTransitionState value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    /**
     * Get the leaseStatus property: The current lease status of the share.
     * 
     * @return the leaseStatus value.
     */
    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    /**
     * Set the leaseStatus property: The current lease status of the share.
     * 
     * @param leaseStatus the leaseStatus value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    /**
     * Get the leaseState property: Lease state of the share.
     * 
     * @return the leaseState value.
     */
    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    /**
     * Set the leaseState property: Lease state of the share.
     * 
     * @param leaseState the leaseState value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    /**
     * Get the leaseDuration property: When a share is leased, specifies whether the lease is of infinite or fixed
     * duration.
     * 
     * @return the leaseDuration value.
     */
    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    /**
     * Set the leaseDuration property: When a share is leased, specifies whether the lease is of infinite or fixed
     * duration.
     * 
     * @param leaseDuration the leaseDuration value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    /**
     * Get the enabledProtocols property: The EnabledProtocols property.
     * 
     * @return the enabledProtocols value.
     */
    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    /**
     * Set the enabledProtocols property: The EnabledProtocols property.
     * 
     * @param enabledProtocols the enabledProtocols value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    /**
     * Get the rootSquash property: The RootSquash property.
     * 
     * @return the rootSquash value.
     */
    public ShareRootSquash getRootSquash() {
        return this.rootSquash;
    }

    /**
     * Set the rootSquash property: The RootSquash property.
     * 
     * @param rootSquash the rootSquash value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setRootSquash(ShareRootSquash rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    /**
     * Get the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @param metadata the metadata value to set.
     * @return the SharePropertiesInternal object itself.
     */
    public SharePropertiesInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SharePropertiesInternal" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeIntElement("Quota", this.quota);
        xmlWriter.writeNumberElement("ProvisionedIops", this.provisionedIops);
        xmlWriter.writeNumberElement("ProvisionedIngressMBps", this.provisionedIngressMBps);
        xmlWriter.writeNumberElement("ProvisionedEgressMBps", this.provisionedEgressMBps);
        xmlWriter.writeNumberElement("ProvisionedBandwidthMiBps", this.provisionedBandwidthMiBps);
        xmlWriter.writeStringElement("NextAllowedQuotaDowngradeTime",
            Objects.toString(this.nextAllowedQuotaDowngradeTime, null));
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeStringElement("AccessTier", this.accessTier);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeStringElement("AccessTierTransitionState", this.accessTierTransitionState);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration",
            this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("EnabledProtocols", this.enabledProtocols);
        xmlWriter.writeStringElement("RootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of SharePropertiesInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of SharePropertiesInternal if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the SharePropertiesInternal.
     */
    public static SharePropertiesInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of SharePropertiesInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of SharePropertiesInternal if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the SharePropertiesInternal.
     */
    public static SharePropertiesInternal fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "SharePropertiesInternal" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            SharePropertiesInternal deserializedSharePropertiesInternal = new SharePropertiesInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.eTag = reader.getStringElement();
                } else if ("Quota".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.quota = reader.getIntElement();
                } else if ("ProvisionedIops".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedIops = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedIngressMBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedIngressMBps
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedEgressMBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedEgressMBps
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedBandwidthMiBps".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.provisionedBandwidthMiBps
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("NextAllowedQuotaDowngradeTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.nextAllowedQuotaDowngradeTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.remainingRetentionDays
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("AccessTier".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTier = reader.getStringElement();
                } else if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTierChangeTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("AccessTierTransitionState".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.accessTierTransitionState = reader.getStringElement();
                } else if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseStatus
                        = LeaseStatusType.fromString(reader.getStringElement());
                } else if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseState
                        = LeaseStateType.fromString(reader.getStringElement());
                } else if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.leaseDuration
                        = LeaseDurationType.fromString(reader.getStringElement());
                } else if ("EnabledProtocols".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.enabledProtocols = reader.getStringElement();
                } else if ("RootSquash".equals(elementName.getLocalPart())) {
                    deserializedSharePropertiesInternal.rootSquash
                        = ShareRootSquash.fromString(reader.getStringElement());
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedSharePropertiesInternal.metadata == null) {
                            deserializedSharePropertiesInternal.metadata = new LinkedHashMap<>();
                        }
                        deserializedSharePropertiesInternal.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedSharePropertiesInternal;
        });
    }
}
