// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Parameter group. */
@JacksonXmlRootElement(localName = "DestinationLeaseAccessConditions")
@Fluent
public final class DestinationLeaseAccessConditions {
    /*
     * Required if the destination file has an active infinite lease. The lease ID specified for this header must match
     * the lease ID of the destination file. If the request does not include the lease ID or it is not valid, the
     * operation fails with status code 412 (Precondition Failed). If this header is specified and the destination file
     * does not currently have an active lease, the operation will also fail with status code 412 (Precondition
     * Failed).
     */
    @JsonProperty(value = "destinationLeaseId")
    private String destinationLeaseId;

    /** Creates an instance of DestinationLeaseAccessConditions class. */
    public DestinationLeaseAccessConditions() {}

    /**
     * Get the destinationLeaseId property: Required if the destination file has an active infinite lease. The lease ID
     * specified for this header must match the lease ID of the destination file. If the request does not include the
     * lease ID or it is not valid, the operation fails with status code 412 (Precondition Failed). If this header is
     * specified and the destination file does not currently have an active lease, the operation will also fail with
     * status code 412 (Precondition Failed).
     *
     * @return the destinationLeaseId value.
     */
    public String getDestinationLeaseId() {
        return this.destinationLeaseId;
    }

    /**
     * Set the destinationLeaseId property: Required if the destination file has an active infinite lease. The lease ID
     * specified for this header must match the lease ID of the destination file. If the request does not include the
     * lease ID or it is not valid, the operation fails with status code 412 (Precondition Failed). If this header is
     * specified and the destination file does not currently have an active lease, the operation will also fail with
     * status code 412 (Precondition Failed).
     *
     * @param destinationLeaseId the destinationLeaseId value to set.
     * @return the DestinationLeaseAccessConditions object itself.
     */
    public DestinationLeaseAccessConditions setDestinationLeaseId(String destinationLeaseId) {
        this.destinationLeaseId = destinationLeaseId;
        return this;
    }
}
