// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

/** The DirectoriesForceCloseHandlesHeaders model. */
@JacksonXmlRootElement(localName = "null")
@Fluent
public final class DirectoriesForceCloseHandlesHeaders {
    /*
     * The x-ms-marker property.
     */
    @JsonProperty(value = "x-ms-marker")
    private String xMsMarker;

    /*
     * The x-ms-version property.
     */
    @JsonProperty(value = "x-ms-version")
    private String xMsVersion;

    /*
     * The x-ms-number-of-handles-closed property.
     */
    @JsonProperty(value = "x-ms-number-of-handles-closed")
    private Integer xMsNumberOfHandlesClosed;

    /*
     * The x-ms-number-of-handles-failed property.
     */
    @JsonProperty(value = "x-ms-number-of-handles-failed")
    private Integer xMsNumberOfHandlesFailed;

    /*
     * The x-ms-request-id property.
     */
    @JsonProperty(value = "x-ms-request-id")
    private String xMsRequestId;

    /*
     * The Date property.
     */
    @JsonProperty(value = "Date")
    private DateTimeRfc1123 date;

    private static final HttpHeaderName X_MS_MARKER = HttpHeaderName.fromString("x-ms-marker");

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_NUMBER_OF_HANDLES_CLOSED =
            HttpHeaderName.fromString("x-ms-number-of-handles-closed");

    private static final HttpHeaderName X_MS_NUMBER_OF_HANDLES_FAILED =
            HttpHeaderName.fromString("x-ms-number-of-handles-failed");

    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of DirectoriesForceCloseHandlesHeaders class.
     *
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public DirectoriesForceCloseHandlesHeaders(HttpHeaders rawHeaders) {
        this.xMsMarker = rawHeaders.getValue(X_MS_MARKER);
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsNumberOfHandlesClosed = rawHeaders.getValue(X_MS_NUMBER_OF_HANDLES_CLOSED);
        if (xMsNumberOfHandlesClosed != null) {
            this.xMsNumberOfHandlesClosed = Integer.parseInt(xMsNumberOfHandlesClosed);
        }
        String xMsNumberOfHandlesFailed = rawHeaders.getValue(X_MS_NUMBER_OF_HANDLES_FAILED);
        if (xMsNumberOfHandlesFailed != null) {
            this.xMsNumberOfHandlesFailed = Integer.parseInt(xMsNumberOfHandlesFailed);
        }
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    /**
     * Get the xMsMarker property: The x-ms-marker property.
     *
     * @return the xMsMarker value.
     */
    public String getXMsMarker() {
        return this.xMsMarker;
    }

    /**
     * Set the xMsMarker property: The x-ms-marker property.
     *
     * @param xMsMarker the xMsMarker value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setXMsMarker(String xMsMarker) {
        this.xMsMarker = xMsMarker;
        return this;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     *
     * @return the xMsVersion value.
     */
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     *
     * @param xMsVersion the xMsVersion value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsNumberOfHandlesClosed property: The x-ms-number-of-handles-closed property.
     *
     * @return the xMsNumberOfHandlesClosed value.
     */
    public Integer getXMsNumberOfHandlesClosed() {
        return this.xMsNumberOfHandlesClosed;
    }

    /**
     * Set the xMsNumberOfHandlesClosed property: The x-ms-number-of-handles-closed property.
     *
     * @param xMsNumberOfHandlesClosed the xMsNumberOfHandlesClosed value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setXMsNumberOfHandlesClosed(Integer xMsNumberOfHandlesClosed) {
        this.xMsNumberOfHandlesClosed = xMsNumberOfHandlesClosed;
        return this;
    }

    /**
     * Get the xMsNumberOfHandlesFailed property: The x-ms-number-of-handles-failed property.
     *
     * @return the xMsNumberOfHandlesFailed value.
     */
    public Integer getXMsNumberOfHandlesFailed() {
        return this.xMsNumberOfHandlesFailed;
    }

    /**
     * Set the xMsNumberOfHandlesFailed property: The x-ms-number-of-handles-failed property.
     *
     * @param xMsNumberOfHandlesFailed the xMsNumberOfHandlesFailed value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setXMsNumberOfHandlesFailed(Integer xMsNumberOfHandlesFailed) {
        this.xMsNumberOfHandlesFailed = xMsNumberOfHandlesFailed;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     *
     * @return the xMsRequestId value.
     */
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     *
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the date property: The Date property.
     *
     * @return the date value.
     */
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     *
     * @param date the date value to set.
     * @return the DirectoriesForceCloseHandlesHeaders object itself.
     */
    public DirectoriesForceCloseHandlesHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }
}
