/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.storage.common.StorageOutputStream;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.models.ShareStorageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class StorageFileOutputStream
extends StorageOutputStream {
    private long offsetPos;
    private final ShareFileAsyncClient client;

    StorageFileOutputStream(ShareFileAsyncClient client, long offsetPos) {
        super(0x400000);
        this.client = client;
        this.offsetPos = offsetPos;
    }

    private Mono<Void> uploadData(Flux<ByteBuffer> inputData, long writeLength, long offset) {
        return this.client.uploadWithResponse(inputData, writeLength, offset).then().onErrorResume(t -> t instanceof IOException || t instanceof ShareStorageException, e -> {
            this.lastError = new IOException((Throwable)e);
            return null;
        });
    }

    protected Mono<Void> dispatchWrite(byte[] data, int writeLength, long offset) {
        if (writeLength == 0) {
            return Mono.empty();
        }
        Flux fbb = Flux.range((int)0, (int)1).concatMap(pos -> Mono.fromCallable(() -> ByteBuffer.wrap(data, (int)offset, writeLength)));
        long fileOffset = this.offsetPos;
        this.offsetPos += (long)writeLength;
        return this.uploadData((Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.boundedElastic()), writeLength, fileOffset);
    }
}

