/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class FilesDownloadHeaders {
    @JsonProperty(value="x-ms-file-id")
    private String xMsFileId;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType xMsLeaseStatus;
    @JsonProperty(value="x-ms-file-creation-time")
    private OffsetDateTime xMsFileCreationTime;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType xMsLeaseState;
    @JsonProperty(value="x-ms-content-md5")
    private byte[] xMsContentMd5;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-file-attributes")
    private String xMsFileAttributes;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="x-ms-copy-status-description")
    private String xMsCopyStatusDescription;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType xMsLeaseDuration;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-file-permission-key")
    private String xMsFilePermissionKey;
    @JsonProperty(value="x-ms-copy-id")
    private String xMsCopyId;
    @JsonProperty(value="x-ms-copy-source")
    private String xMsCopySource;
    @JsonProperty(value="x-ms-copy-progress")
    private String xMsCopyProgress;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 xMsCopyCompletionTime;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean xMsServerEncrypted;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="x-ms-file-change-time")
    private OffsetDateTime xMsFileChangeTime;
    @JsonProperty(value="x-ms-file-parent-id")
    private String xMsFileParentId;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType xMsCopyStatus;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-file-last-write-time")
    private OffsetDateTime xMsFileLastWriteTime;

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public FilesDownloadHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public FilesDownloadHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public FilesDownloadHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public FilesDownloadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public FilesDownloadHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public byte[] getXMsContentMd5() {
        return CoreUtils.clone((byte[])this.xMsContentMd5);
    }

    public FilesDownloadHeaders setXMsContentMd5(byte[] xMsContentMd5) {
        this.xMsContentMd5 = CoreUtils.clone((byte[])xMsContentMd5);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    public FilesDownloadHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public FilesDownloadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public FilesDownloadHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public FilesDownloadHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public FilesDownloadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesDownloadHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public FilesDownloadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesDownloadHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    public FilesDownloadHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public FilesDownloadHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public FilesDownloadHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public FilesDownloadHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public FilesDownloadHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public FilesDownloadHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public FilesDownloadHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public FilesDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public FilesDownloadHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public FilesDownloadHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public FilesDownloadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesDownloadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public FilesDownloadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public FilesDownloadHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public FilesDownloadHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public FilesDownloadHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public FilesDownloadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesDownloadHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }
}

