/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.SignedIdentifiersWrapper;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesBreakLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionResponse;
import com.azure.storage.file.share.implementation.models.SharesCreateResponse;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.share.implementation.models.SharesDeleteResponse;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyResponse;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionResponse;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsResponse;
import com.azure.storage.file.share.implementation.models.SharesReleaseLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesRestoreResponse;
import com.azure.storage.file.share.implementation.models.SharesSetAccessPolicyResponse;
import com.azure.storage.file.share.implementation.models.SharesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.SharesSetPropertiesResponse;
import com.azure.storage.file.share.models.ShareAccessTier;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SharesImpl {
    private final SharesService service;
    private final AzureFileStorageImpl client;

    SharesImpl(AzureFileStorageImpl client) {
        this.service = (SharesService)RestProxy.create(SharesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesCreateResponse> createWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesGetPropertiesResponse> getPropertiesWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesDeleteResponse> deleteWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesAcquireLeaseResponse> acquireLeaseWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        String accept = "application/xml";
        return this.service.acquireLease(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesReleaseLeaseResponse> releaseLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        String accept = "application/xml";
        return this.service.releaseLease(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesChangeLeaseResponse> changeLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        String accept = "application/xml";
        return this.service.changeLease(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesRenewLeaseResponse> renewLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        String accept = "application/xml";
        return this.service.renewLease(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesBreakLeaseResponse> breakLeaseWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        String accept = "application/xml";
        return this.service.breakLease(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesCreateSnapshotResponse> createSnapshotWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        String accept = "application/xml";
        return this.service.createSnapshot(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesCreatePermissionResponse> createPermissionWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/xml";
        return this.service.createPermission(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), sharePermission, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesGetPermissionResponse> getPermissionWithResponseAsync(String shareName, String filePermissionKey, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/json";
        return this.service.getPermission(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, timeout, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesSetPropertiesResponse> setPropertiesWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesSetMetadataResponse> setMetadataWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String restype = "share";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesGetAccessPolicyResponse> getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesSetAccessPolicyResponse> setAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(shareAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, shareAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesGetStatisticsResponse> getStatisticsWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharesRestoreResponse> restoreWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        String restype = "share";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restore(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageShar")
    public static interface SharesService {
        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreateResponse> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesAcquireLeaseResponse> acquireLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesReleaseLeaseResponse> releaseLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesChangeLeaseResponse> changeLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesRenewLeaseResponse> renewLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesBreakLeaseResponse> breakLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreateSnapshotResponse> createSnapshot(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreatePermissionResponse> createPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @BodyParam(value="application/json") SharePermission var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetPermissionResponse> getPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetAccessPolicyResponse> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetAccessPolicyResponse> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @BodyParam(value="application/xml") SignedIdentifiersWrapper var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetStatisticsResponse> getStatistics(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesRestoreResponse> restore(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

