/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageInputStream;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareStorageException;
import java.io.IOException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public class StorageFileInputStream
extends StorageInputStream {
    private final ClientLogger logger = new ClientLogger(StorageFileInputStream.class);
    private final ShareFileAsyncClient shareFileAsyncClient;

    StorageFileInputStream(ShareFileAsyncClient shareFileAsyncClient) throws ShareStorageException {
        this(shareFileAsyncClient, 0L, null);
    }

    StorageFileInputStream(ShareFileAsyncClient shareFileAsyncClient, long fileRangeOffset, Long fileRangeLength) throws ShareStorageException {
        super(fileRangeOffset, fileRangeLength, 0x400000, ((ShareFileProperties)shareFileAsyncClient.getProperties().block()).getContentLength().longValue());
        this.shareFileAsyncClient = shareFileAsyncClient;
    }

    protected synchronized ByteBuffer dispatchRead(int readLength, long offset) {
        try {
            ByteBuffer currentBuffer = (ByteBuffer)this.shareFileAsyncClient.downloadWithResponse(new ShareFileRange(offset, offset + (long)readLength - 1L), false).flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue())).map(ByteBuffer::wrap)).block();
            this.bufferSize = readLength;
            this.bufferStartOffset = offset;
            return currentBuffer;
        }
        catch (ShareStorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException((Throwable)((Object)e));
            throw this.logger.logExceptionAsError(new RuntimeException(this.lastError.getMessage()));
        }
    }
}

