/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.FileSystemsCreateResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsDeleteResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsGetPropertiesResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsResponse;
import com.azure.storage.file.datalake.implementation.models.FileSystemsSetPropertiesResponse;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class FileSystemsImpl {
    private final FileSystemsService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    FileSystemsImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = (FileSystemsService)RestProxy.create(FileSystemsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemsCreateResponse> createWithResponseAsync(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        return this.service.create(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemsSetPropertiesResponse> setPropertiesWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setProperties(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemsGetPropertiesResponse> getPropertiesWithResponseAsync(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        return this.service.getProperties(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemsDeleteResponse> deleteWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemsListPathsResponse> listPathsWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        return this.service.listPaths(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface FileSystemsService {
        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsCreateResponse> create(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-properties") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-properties") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsDeleteResponse> delete(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<FileSystemsListPathsResponse> listPaths(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);
    }
}

