/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.FileSystemItem;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.FileSystemUndeleteOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataLakeServiceClientBuilder.class, isAsync=true)
public class DataLakeServiceAsyncClient {
    private final ClientLogger logger = new ClientLogger(DataLakeServiceAsyncClient.class);
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final String accountName;
    private final DataLakeServiceVersion serviceVersion;
    private final BlobServiceAsyncClient blobServiceAsyncClient;

    DataLakeServiceAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, BlobServiceAsyncClient blobServiceAsyncClient) {
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.blobServiceAsyncClient = blobServiceAsyncClient;
    }

    public DataLakeFileSystemAsyncClient getFileSystemAsyncClient(String fileSystemName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)fileSystemName)) {
            fileSystemName = "$root";
        }
        return new DataLakeFileSystemAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), fileSystemName, this.blobServiceAsyncClient.getBlobContainerAsyncClient(fileSystemName));
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileSystemAsyncClient> createFileSystem(String fileSystemName) {
        try {
            return this.createFileSystemWithResponse(fileSystemName, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileSystemAsyncClient>> createFileSystemWithResponse(String fileSystemName, Map<String, String> metadata, PublicAccessType accessType) {
        try {
            DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient = this.getFileSystemAsyncClient(fileSystemName);
            return dataLakeFileSystemAsyncClient.createWithResponse(metadata, accessType).map(response -> new SimpleResponse(response, (Object)dataLakeFileSystemAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFileSystem(String fileSystemName) {
        try {
            return this.deleteFileSystemWithResponse(fileSystemName, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileSystemWithResponse(String fileSystemName, DataLakeRequestConditions requestConditions) {
        try {
            return this.getFileSystemAsyncClient(fileSystemName).deleteWithResponse(requestConditions);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystemItem> listFileSystems() {
        try {
            return this.listFileSystems(new ListFileSystemsOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystemItem> listFileSystems(ListFileSystemsOptions options) {
        try {
            return this.listFileSystemsWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<FileSystemItem> listFileSystemsWithOptionalTimeout(ListFileSystemsOptions options, Duration timeout) {
        PagedFlux inputPagedFlux = this.blobServiceAsyncClient.listBlobContainers(Transforms.toListBlobContainersOptions(options));
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken != null && pageSize != null ? inputPagedFlux.byPage(continuationToken, pageSize.intValue()) : (continuationToken != null ? inputPagedFlux.byPage(continuationToken) : (pageSize != null ? inputPagedFlux.byPage(pageSize.intValue()) : inputPagedFlux.byPage()));
            flux = flux.onErrorMap(DataLakeImplUtils::transformBlobStorageException);
            if (timeout != null) {
                flux = flux.timeout(timeout);
            }
            return flux.map(blobsPagedResponse -> new PagedResponseBase(blobsPagedResponse.getRequest(), blobsPagedResponse.getStatusCode(), blobsPagedResponse.getHeaders(), blobsPagedResponse.getValue().stream().map(Transforms::toFileSystemItem).collect(Collectors.toList()), (String)blobsPagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return this.getUserDelegationKeyWithResponse(start, expiry).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return this.blobServiceAsyncClient.getUserDelegationKeyWithResponse(start, expiry).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toDataLakeUserDelegationKey((com.azure.storage.blob.models.UserDelegationKey)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileSystemAsyncClient> undeleteFileSystem(String deletedFileSystemName, String deletedFileSystemVersion) {
        return this.undeleteFileSystemWithResponse(new FileSystemUndeleteOptions(deletedFileSystemName, deletedFileSystemVersion)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileSystemAsyncClient>> undeleteFileSystemWithResponse(FileSystemUndeleteOptions options) {
        try {
            return this.blobServiceAsyncClient.undeleteBlobContainerWithResponse(Transforms.toBlobContainerUndeleteOptions(options)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)this.getFileSystemAsyncClient(((BlobContainerAsyncClient)response.getValue()).getBlobContainerName())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

