/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.options;

import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;

public class FileParallelUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final long length;
    private ParallelTransferOptions parallelTransferOptions;
    private PathHttpHeaders headers;
    private Map<String, String> metadata;
    private String permissions;
    private String umask;
    private DataLakeRequestConditions requestConditions;

    public FileParallelUploadOptions(Flux<ByteBuffer> dataFlux) {
        StorageImplUtils.assertNotNull((String)"dataFlux", dataFlux);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = -1L;
    }

    public FileParallelUploadOptions(InputStream dataStream, long length) {
        StorageImplUtils.assertNotNull((String)"dataStream", (Object)length);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)0L, (long)Long.MAX_VALUE);
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public long getLength() {
        return this.length;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public FileParallelUploadOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public PathHttpHeaders getHeaders() {
        return this.headers;
    }

    public FileParallelUploadOptions setHeaders(PathHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FileParallelUploadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public FileParallelUploadOptions setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public String getUmask() {
        return this.umask;
    }

    public FileParallelUploadOptions setUmask(String umask) {
        this.umask = umask;
        return this;
    }

    public DataLakeRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public FileParallelUploadOptions setRequestConditions(DataLakeRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }
}

