/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientImpl;
import com.azure.storage.file.datalake.implementation.models.ServicesListFileSystemsResponse;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private ServicesService service;
    private DataLakeStorageClientImpl client;

    public ServicesImpl(DataLakeStorageClientImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<ServicesListFileSystemsResponse> listFileSystemsWithRestResponseAsync(Context context) {
        String resource = "account";
        String prefix = null;
        String continuation = null;
        Integer maxResults = null;
        String requestId = null;
        Integer timeout = null;
        return this.service.listFileSystems(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), context);
    }

    public Mono<ServicesListFileSystemsResponse> listFileSystemsWithRestResponseAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        String resource = "account";
        return this.service.listFileSystems(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="DataLakeStorageClientServices")
    private static interface ServicesService {
        @Get(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<ServicesListFileSystemsResponse> listFileSystems(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, Context var9);
    }
}

