/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.DataLakeStorageExceptionInternal;
import com.azure.storage.file.datalake.implementation.models.FileSystemsCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsDeleteHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsSetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.file.datalake.implementation.models.ListBlobsIncludeItem;
import com.azure.storage.file.datalake.implementation.models.ListBlobsShowOnly;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathList;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class FileSystemsImpl {
    private final FileSystemsService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    FileSystemsImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = (FileSystemsService)RestProxy.create(FileSystemsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, String properties) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> createWithResponseAsync(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        return this.service.create(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, String properties) {
        return this.createWithResponseAsync(requestId, timeout, properties).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String requestId, Integer timeout, String properties, Context context) {
        return this.createWithResponseAsync(requestId, timeout, properties, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String properties) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        return this.service.createNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsCreateHeaders, Void> createWithResponse(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        try {
            return this.service.createSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String requestId, Integer timeout, String properties) {
        this.createWithResponse(requestId, timeout, properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String requestId, Integer timeout, String properties, Context context) {
        String accept = "application/json";
        try {
            return this.service.createNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        return this.setPropertiesWithResponseAsync(requestId, timeout, properties, modifiedAccessConditions).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.setPropertiesWithResponseAsync(requestId, timeout, properties, modifiedAccessConditions, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsSetPropertiesHeaders, Void> setPropertiesWithResponse(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        try {
            return this.service.setPropertiesSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions) {
        this.setPropertiesWithResponse(requestId, timeout, properties, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesNoCustomHeadersWithResponse(String requestId, Integer timeout, String properties, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        try {
            return this.service.setPropertiesNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), properties, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        return this.service.getProperties(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout) {
        return this.getPropertiesWithResponseAsync(requestId, timeout).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String requestId, Integer timeout, Context context) {
        return this.getPropertiesWithResponseAsync(requestId, timeout, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsGetPropertiesHeaders, Void> getPropertiesWithResponse(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        try {
            return this.service.getPropertiesSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String requestId, Integer timeout) {
        this.getPropertiesWithResponse(requestId, timeout, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String requestId, Integer timeout, Context context) {
        String accept = "application/json";
        try {
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> deleteWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        return this.deleteWithResponseAsync(requestId, timeout, modifiedAccessConditions).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        return this.deleteWithResponseAsync(requestId, timeout, modifiedAccessConditions, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.deleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsDeleteHeaders, Void> deleteWithResponse(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        try {
            return this.service.deleteSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions) {
        this.deleteWithResponse(requestId, timeout, modifiedAccessConditions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String requestId, Integer timeout, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String accept = "application/json";
        OffsetDateTime ifModifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSinceInternal = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifModifiedSince = ifModifiedSinceInternal;
        OffsetDateTime ifUnmodifiedSinceInternal = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSinceInternal = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = ifUnmodifiedSinceInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        try {
            return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), ifModifiedSinceConverted, ifUnmodifiedSinceConverted, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPathsWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPaths(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPathsWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        return this.service.listPaths(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathList> listPathsAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        return this.listPathsWithResponseAsync(recursive, requestId, timeout, continuation, path, maxResults, upn).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(res -> Mono.justOrEmpty((Object)((PathList)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PathList> listPathsAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        return this.listPathsWithResponseAsync(recursive, requestId, timeout, continuation, path, maxResults, upn, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(res -> Mono.justOrEmpty((Object)((PathList)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathList>> listPathsNoCustomHeadersWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPathsNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PathList>> listPathsNoCustomHeadersWithResponseAsync(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        return this.service.listPathsNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsListPathsHeaders, PathList> listPathsWithResponse(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        try {
            return this.service.listPathsSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PathList listPaths(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn) {
        try {
            return (PathList)this.listPathsWithResponse(recursive, requestId, timeout, continuation, path, maxResults, upn, Context.NONE).getValue();
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PathList> listPathsNoCustomHeadersWithResponse(boolean recursive, String requestId, Integer timeout, String continuation, String path, Integer maxResults, Boolean upn, Context context) {
        String accept = "application/json";
        try {
            return this.service.listPathsNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), this.client.getResource(), requestId, timeout, this.client.getVersion(), continuation, path, recursive, maxResults, upn, "application/json", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobHierarchySegment(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobHierarchySegment(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        return this.listBlobHierarchySegmentWithResponseAsync(prefix, delimiter, marker, maxResults, include, showonly, timeout, requestId).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsHierarchySegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        return this.listBlobHierarchySegmentWithResponseAsync(prefix, delimiter, marker, maxResults, include, showonly, timeout, requestId, context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsHierarchySegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobHierarchySegmentNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.listBlobHierarchySegmentNoCustomHeaders(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentWithResponse(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        try {
            return this.service.listBlobHierarchySegmentSync(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListBlobsHierarchySegmentResponse listBlobHierarchySegment(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId) {
        try {
            return (ListBlobsHierarchySegmentResponse)this.listBlobHierarchySegmentWithResponse(prefix, delimiter, marker, maxResults, include, showonly, timeout, requestId, Context.NONE).getValue();
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentNoCustomHeadersWithResponse(String prefix, String delimiter, String marker, Integer maxResults, List<ListBlobsIncludeItem> include, ListBlobsShowOnly showonly, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        try {
            return this.service.listBlobHierarchySegmentNoCustomHeadersSync(this.client.getUrl(), this.client.getFileSystem(), "container", "list", prefix, delimiter, marker, maxResults, includeConverted, showonly, timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface FileSystemsService {
        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{filesystem}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<Void>> setPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsSetPropertiesHeaders, Void> setPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Patch(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<Void> setPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Head(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Delete(value="/{filesystem}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPaths(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<PathList>> listPathsNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsListPathsHeaders, PathList> listPathsSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<PathList> listPathsNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="resource") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="continuation") String var7, @QueryParam(value="directory") String var8, @QueryParam(value="recursive") boolean var9, @QueryParam(value="maxResults") Integer var10, @QueryParam(value="upn") Boolean var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegment(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxResults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="showonly") ListBlobsShowOnly var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxResults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="showonly") ListBlobsShowOnly var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxResults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="showonly") ListBlobsShowOnly var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{filesystem}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="filesystem") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxResults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="showonly") ListBlobsShowOnly var10, @QueryParam(value="timeout") Integer var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @HeaderParam(value="Accept") String var14, Context var15);
    }
}

