/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeServiceProperties;
import com.azure.storage.file.datalake.models.FileSystemItem;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.FileSystemUndeleteOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Consumer;

@ServiceClient(builder=DataLakeServiceClientBuilder.class)
public class DataLakeServiceClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeServiceClient.class);
    private final DataLakeServiceAsyncClient dataLakeServiceAsyncClient;
    final BlobServiceClient blobServiceClient;
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final String accountName;
    private final DataLakeServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;

    DataLakeServiceClient(DataLakeServiceAsyncClient dataLakeServiceAsyncClient, BlobServiceClient blobServiceClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, AzureSasCredential sasToken, boolean isTokenCredentialAuthenticated) {
        this.dataLakeServiceAsyncClient = dataLakeServiceAsyncClient;
        this.blobServiceClient = blobServiceClient;
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.sasToken = sasToken;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
    }

    public DataLakeFileSystemClient getFileSystemClient(String fileSystemName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)fileSystemName)) {
            fileSystemName = "$root";
        }
        return new DataLakeFileSystemClient(this.dataLakeServiceAsyncClient.getFileSystemAsyncClient(fileSystemName), this.blobServiceClient.getBlobContainerClient(fileSystemName), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), fileSystemName, this.sasToken, this.isTokenCredentialAuthenticated);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileSystemClient createFileSystem(String fileSystemName) {
        return (DataLakeFileSystemClient)this.createFileSystemWithResponse(fileSystemName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileSystemClient> createFileSystemWithResponse(String fileSystemName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        DataLakeFileSystemClient client = this.getFileSystemClient(fileSystemName);
        return new SimpleResponse(client.createWithResponse(metadata, accessType, null, context), (Object)client);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFileSystem(String fileSystemName) {
        this.deleteFileSystemWithResponse(fileSystemName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileSystemWithResponse(String fileSystemName, DataLakeRequestConditions requestConditions, Context context) {
        return this.getFileSystemClient(fileSystemName).deleteWithResponse(requestConditions, null, context);
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystemItem> listFileSystems() {
        return this.listFileSystems(new ListFileSystemsOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystemItem> listFileSystems(ListFileSystemsOptions options, Duration timeout) {
        return new PagedIterable(this.dataLakeServiceAsyncClient.listFileSystemsWithOptionalTimeout(options, timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeServiceProperties getProperties() {
        return (DataLakeServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return (Response)DataLakeImplUtils.returnOrConvertException(() -> {
            Response response = this.blobServiceClient.getPropertiesWithResponse(timeout, context);
            return new SimpleResponse(response, (Object)Transforms.toDataLakeServiceProperties((BlobServiceProperties)response.getValue()));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(DataLakeServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(DataLakeServiceProperties properties, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobServiceClient.setPropertiesWithResponse(Transforms.toBlobServiceProperties(properties), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserDelegationKey getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return (UserDelegationKey)this.getUserDelegationKeyWithResponse(start, expiry, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserDelegationKey> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Duration timeout, Context context) {
        return (Response)DataLakeImplUtils.returnOrConvertException(() -> {
            Response response = this.blobServiceClient.getUserDelegationKeyWithResponse(start, expiry, timeout, context);
            return new SimpleResponse(response, (Object)Transforms.toDataLakeUserDelegationKey((com.azure.storage.blob.models.UserDelegationKey)response.getValue()));
        }, LOGGER);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, null);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return this.blobServiceClient.generateAccountSas(accountSasSignatureValues, stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileSystemClient undeleteFileSystem(String deletedFileSystemName, String deletedFileSystemVersion) {
        return (DataLakeFileSystemClient)this.undeleteFileSystemWithResponse(new FileSystemUndeleteOptions(deletedFileSystemName, deletedFileSystemVersion), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileSystemClient> undeleteFileSystemWithResponse(FileSystemUndeleteOptions options, Duration timeout, Context context) {
        return (Response)DataLakeImplUtils.returnOrConvertException(() -> {
            Response response = this.blobServiceClient.undeleteBlobContainerWithResponse(Transforms.toBlobContainerUndeleteOptions(options), timeout, context);
            return new SimpleResponse(response, (Object)this.getFileSystemClient(((BlobContainerClient)response.getValue()).getBlobContainerName()));
        }, LOGGER);
    }
}

