// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SetAccessControlRecursiveResponse model.
 */
@Fluent
public final class SetAccessControlRecursiveResponse implements JsonSerializable<SetAccessControlRecursiveResponse> {
    /*
     * The directoriesSuccessful property.
     */
    private Integer directoriesSuccessful;

    /*
     * The filesSuccessful property.
     */
    private Integer filesSuccessful;

    /*
     * The failureCount property.
     */
    private Integer failureCount;

    /*
     * The failedEntries property.
     */
    private List<AclFailedEntry> failedEntries;

    /**
     * Creates an instance of SetAccessControlRecursiveResponse class.
     */
    public SetAccessControlRecursiveResponse() {
    }

    /**
     * Get the directoriesSuccessful property: The directoriesSuccessful property.
     * 
     * @return the directoriesSuccessful value.
     */
    public Integer getDirectoriesSuccessful() {
        return this.directoriesSuccessful;
    }

    /**
     * Set the directoriesSuccessful property: The directoriesSuccessful property.
     * 
     * @param directoriesSuccessful the directoriesSuccessful value to set.
     * @return the SetAccessControlRecursiveResponse object itself.
     */
    public SetAccessControlRecursiveResponse setDirectoriesSuccessful(Integer directoriesSuccessful) {
        this.directoriesSuccessful = directoriesSuccessful;
        return this;
    }

    /**
     * Get the filesSuccessful property: The filesSuccessful property.
     * 
     * @return the filesSuccessful value.
     */
    public Integer getFilesSuccessful() {
        return this.filesSuccessful;
    }

    /**
     * Set the filesSuccessful property: The filesSuccessful property.
     * 
     * @param filesSuccessful the filesSuccessful value to set.
     * @return the SetAccessControlRecursiveResponse object itself.
     */
    public SetAccessControlRecursiveResponse setFilesSuccessful(Integer filesSuccessful) {
        this.filesSuccessful = filesSuccessful;
        return this;
    }

    /**
     * Get the failureCount property: The failureCount property.
     * 
     * @return the failureCount value.
     */
    public Integer getFailureCount() {
        return this.failureCount;
    }

    /**
     * Set the failureCount property: The failureCount property.
     * 
     * @param failureCount the failureCount value to set.
     * @return the SetAccessControlRecursiveResponse object itself.
     */
    public SetAccessControlRecursiveResponse setFailureCount(Integer failureCount) {
        this.failureCount = failureCount;
        return this;
    }

    /**
     * Get the failedEntries property: The failedEntries property.
     * 
     * @return the failedEntries value.
     */
    public List<AclFailedEntry> getFailedEntries() {
        return this.failedEntries;
    }

    /**
     * Set the failedEntries property: The failedEntries property.
     * 
     * @param failedEntries the failedEntries value to set.
     * @return the SetAccessControlRecursiveResponse object itself.
     */
    public SetAccessControlRecursiveResponse setFailedEntries(List<AclFailedEntry> failedEntries) {
        this.failedEntries = failedEntries;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("directoriesSuccessful", this.directoriesSuccessful);
        jsonWriter.writeNumberField("filesSuccessful", this.filesSuccessful);
        jsonWriter.writeNumberField("failureCount", this.failureCount);
        jsonWriter.writeArrayField("failedEntries", this.failedEntries, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SetAccessControlRecursiveResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SetAccessControlRecursiveResponse if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SetAccessControlRecursiveResponse.
     */
    public static SetAccessControlRecursiveResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SetAccessControlRecursiveResponse deserializedSetAccessControlRecursiveResponse
                = new SetAccessControlRecursiveResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("directoriesSuccessful".equals(fieldName)) {
                    deserializedSetAccessControlRecursiveResponse.directoriesSuccessful
                        = reader.getNullable(JsonReader::getInt);
                } else if ("filesSuccessful".equals(fieldName)) {
                    deserializedSetAccessControlRecursiveResponse.filesSuccessful
                        = reader.getNullable(JsonReader::getInt);
                } else if ("failureCount".equals(fieldName)) {
                    deserializedSetAccessControlRecursiveResponse.failureCount = reader.getNullable(JsonReader::getInt);
                } else if ("failedEntries".equals(fieldName)) {
                    List<AclFailedEntry> failedEntries = reader.readArray(reader1 -> AclFailedEntry.fromJson(reader1));
                    deserializedSetAccessControlRecursiveResponse.failedEntries = failedEntries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSetAccessControlRecursiveResponse;
        });
    }
}
