// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The PathList model.
 */
@Fluent
public final class PathList implements JsonSerializable<PathList> {
    /*
     * The paths property.
     */
    private List<Path> paths;

    /**
     * Creates an instance of PathList class.
     */
    public PathList() {
    }

    /**
     * Get the paths property: The paths property.
     * 
     * @return the paths value.
     */
    public List<Path> getPaths() {
        return this.paths;
    }

    /**
     * Set the paths property: The paths property.
     * 
     * @param paths the paths value to set.
     * @return the PathList object itself.
     */
    public PathList setPaths(List<Path> paths) {
        this.paths = paths;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("paths", this.paths, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PathList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PathList if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the PathList.
     */
    public static PathList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PathList deserializedPathList = new PathList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("paths".equals(fieldName)) {
                    List<Path> paths = reader.readArray(reader1 -> Path.fromJson(reader1));
                    deserializedPathList.paths = paths;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPathList;
        });
    }
}
