// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The FileSystemList model.
 */
@Fluent
public final class FileSystemList implements JsonSerializable<FileSystemList> {
    /*
     * The filesystems property.
     */
    private List<FileSystem> filesystems;

    /**
     * Creates an instance of FileSystemList class.
     */
    public FileSystemList() {
    }

    /**
     * Get the filesystems property: The filesystems property.
     * 
     * @return the filesystems value.
     */
    public List<FileSystem> getFilesystems() {
        return this.filesystems;
    }

    /**
     * Set the filesystems property: The filesystems property.
     * 
     * @param filesystems the filesystems value to set.
     * @return the FileSystemList object itself.
     */
    public FileSystemList setFilesystems(List<FileSystem> filesystems) {
        this.filesystems = filesystems;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("filesystems", this.filesystems, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSystemList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSystemList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FileSystemList.
     */
    public static FileSystemList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSystemList deserializedFileSystemList = new FileSystemList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("filesystems".equals(fieldName)) {
                    List<FileSystem> filesystems = reader.readArray(reader1 -> FileSystem.fromJson(reader1));
                    deserializedFileSystemList.filesystems = filesystems;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileSystemList;
        });
    }
}
