// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Properties of a blob.
 */
@Fluent
public final class BlobPropertiesInternal implements XmlSerializable<BlobPropertiesInternal> {
    /*
     * The Creation-Time property.
     */
    private DateTimeRfc1123 creationTime;

    /*
     * The Last-Modified property.
     */
    private DateTimeRfc1123 lastModified;

    /*
     * The Etag property.
     */
    private String etag;

    /*
     * Size in bytes
     */
    private Long contentLength;

    /*
     * The Content-Type property.
     */
    private String contentType;

    /*
     * The Content-Encoding property.
     */
    private String contentEncoding;

    /*
     * The Content-Language property.
     */
    private String contentLanguage;

    /*
     * The Content-MD5 property.
     */
    private byte[] contentMD5;

    /*
     * The Content-Disposition property.
     */
    private String contentDisposition;

    /*
     * The Cache-Control property.
     */
    private String cacheControl;

    /*
     * The x-ms-blob-sequence-number property.
     */
    private Long blobSequenceNumber;

    /*
     * The CopyId property.
     */
    private String copyId;

    /*
     * The CopySource property.
     */
    private String copySource;

    /*
     * The CopyProgress property.
     */
    private String copyProgress;

    /*
     * The CopyCompletionTime property.
     */
    private DateTimeRfc1123 copyCompletionTime;

    /*
     * The CopyStatusDescription property.
     */
    private String copyStatusDescription;

    /*
     * The ServerEncrypted property.
     */
    private Boolean serverEncrypted;

    /*
     * The IncrementalCopy property.
     */
    private Boolean incrementalCopy;

    /*
     * The DestinationSnapshot property.
     */
    private String destinationSnapshot;

    /*
     * The DeletedTime property.
     */
    private DateTimeRfc1123 deletedTime;

    /*
     * The RemainingRetentionDays property.
     */
    private Integer remainingRetentionDays;

    /*
     * The AccessTierInferred property.
     */
    private Boolean accessTierInferred;

    /*
     * The CustomerProvidedKeySha256 property.
     */
    private String customerProvidedKeySha256;

    /*
     * The name of the encryption scope under which the blob is encrypted.
     */
    private String encryptionScope;

    /*
     * The AccessTierChangeTime property.
     */
    private DateTimeRfc1123 accessTierChangeTime;

    /*
     * The TagCount property.
     */
    private Integer tagCount;

    /*
     * The Expiry-Time property.
     */
    private DateTimeRfc1123 expiresOn;

    /*
     * The Sealed property.
     */
    private Boolean isSealed;

    /*
     * The LastAccessTime property.
     */
    private DateTimeRfc1123 lastAccessedOn;

    /*
     * The DeleteTime property.
     */
    private DateTimeRfc1123 deleteTime;

    /**
     * Creates an instance of BlobPropertiesInternal class.
     */
    public BlobPropertiesInternal() {
    }

    /**
     * Get the creationTime property: The Creation-Time property.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    /**
     * Set the creationTime property: The Creation-Time property.
     * 
     * @param creationTime the creationTime value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCreationTime(OffsetDateTime creationTime) {
        if (creationTime == null) {
            this.creationTime = null;
        } else {
            this.creationTime = new DateTimeRfc1123(creationTime);
        }
        return this;
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     * 
     * @param lastModified the lastModified value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the etag property: The Etag property.
     * 
     * @return the etag value.
     */
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: The Etag property.
     * 
     * @param etag the etag value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the contentLength property: Size in bytes.
     * 
     * @return the contentLength value.
     */
    public Long getContentLength() {
        return this.contentLength;
    }

    /**
     * Set the contentLength property: Size in bytes.
     * 
     * @param contentLength the contentLength value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    /**
     * Get the contentType property: The Content-Type property.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The Content-Type property.
     * 
     * @param contentType the contentType value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the contentEncoding property: The Content-Encoding property.
     * 
     * @return the contentEncoding value.
     */
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    /**
     * Set the contentEncoding property: The Content-Encoding property.
     * 
     * @param contentEncoding the contentEncoding value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    /**
     * Get the contentLanguage property: The Content-Language property.
     * 
     * @return the contentLanguage value.
     */
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    /**
     * Set the contentLanguage property: The Content-Language property.
     * 
     * @param contentLanguage the contentLanguage value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    /**
     * Get the contentMD5 property: The Content-MD5 property.
     * 
     * @return the contentMD5 value.
     */
    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    /**
     * Set the contentMD5 property: The Content-MD5 property.
     * 
     * @param contentMD5 the contentMD5 value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    /**
     * Get the contentDisposition property: The Content-Disposition property.
     * 
     * @return the contentDisposition value.
     */
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    /**
     * Set the contentDisposition property: The Content-Disposition property.
     * 
     * @param contentDisposition the contentDisposition value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    /**
     * Get the cacheControl property: The Cache-Control property.
     * 
     * @return the cacheControl value.
     */
    public String getCacheControl() {
        return this.cacheControl;
    }

    /**
     * Set the cacheControl property: The Cache-Control property.
     * 
     * @param cacheControl the cacheControl value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    /**
     * Get the blobSequenceNumber property: The x-ms-blob-sequence-number property.
     * 
     * @return the blobSequenceNumber value.
     */
    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    /**
     * Set the blobSequenceNumber property: The x-ms-blob-sequence-number property.
     * 
     * @param blobSequenceNumber the blobSequenceNumber value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    /**
     * Get the copyId property: The CopyId property.
     * 
     * @return the copyId value.
     */
    public String getCopyId() {
        return this.copyId;
    }

    /**
     * Set the copyId property: The CopyId property.
     * 
     * @param copyId the copyId value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    /**
     * Get the copySource property: The CopySource property.
     * 
     * @return the copySource value.
     */
    public String getCopySource() {
        return this.copySource;
    }

    /**
     * Set the copySource property: The CopySource property.
     * 
     * @param copySource the copySource value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    /**
     * Get the copyProgress property: The CopyProgress property.
     * 
     * @return the copyProgress value.
     */
    public String getCopyProgress() {
        return this.copyProgress;
    }

    /**
     * Set the copyProgress property: The CopyProgress property.
     * 
     * @param copyProgress the copyProgress value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    /**
     * Get the copyCompletionTime property: The CopyCompletionTime property.
     * 
     * @return the copyCompletionTime value.
     */
    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    /**
     * Set the copyCompletionTime property: The CopyCompletionTime property.
     * 
     * @param copyCompletionTime the copyCompletionTime value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        if (copyCompletionTime == null) {
            this.copyCompletionTime = null;
        } else {
            this.copyCompletionTime = new DateTimeRfc1123(copyCompletionTime);
        }
        return this;
    }

    /**
     * Get the copyStatusDescription property: The CopyStatusDescription property.
     * 
     * @return the copyStatusDescription value.
     */
    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    /**
     * Set the copyStatusDescription property: The CopyStatusDescription property.
     * 
     * @param copyStatusDescription the copyStatusDescription value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    /**
     * Get the serverEncrypted property: The ServerEncrypted property.
     * 
     * @return the serverEncrypted value.
     */
    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    /**
     * Set the serverEncrypted property: The ServerEncrypted property.
     * 
     * @param serverEncrypted the serverEncrypted value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    /**
     * Get the incrementalCopy property: The IncrementalCopy property.
     * 
     * @return the incrementalCopy value.
     */
    public Boolean isIncrementalCopy() {
        return this.incrementalCopy;
    }

    /**
     * Set the incrementalCopy property: The IncrementalCopy property.
     * 
     * @param incrementalCopy the incrementalCopy value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setIncrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    /**
     * Get the destinationSnapshot property: The DestinationSnapshot property.
     * 
     * @return the destinationSnapshot value.
     */
    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    /**
     * Set the destinationSnapshot property: The DestinationSnapshot property.
     * 
     * @param destinationSnapshot the destinationSnapshot value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    /**
     * Get the deletedTime property: The DeletedTime property.
     * 
     * @return the deletedTime value.
     */
    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    /**
     * Set the deletedTime property: The DeletedTime property.
     * 
     * @param deletedTime the deletedTime value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        if (deletedTime == null) {
            this.deletedTime = null;
        } else {
            this.deletedTime = new DateTimeRfc1123(deletedTime);
        }
        return this;
    }

    /**
     * Get the remainingRetentionDays property: The RemainingRetentionDays property.
     * 
     * @return the remainingRetentionDays value.
     */
    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Set the remainingRetentionDays property: The RemainingRetentionDays property.
     * 
     * @param remainingRetentionDays the remainingRetentionDays value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    /**
     * Get the accessTierInferred property: The AccessTierInferred property.
     * 
     * @return the accessTierInferred value.
     */
    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    /**
     * Set the accessTierInferred property: The AccessTierInferred property.
     * 
     * @param accessTierInferred the accessTierInferred value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    /**
     * Get the customerProvidedKeySha256 property: The CustomerProvidedKeySha256 property.
     * 
     * @return the customerProvidedKeySha256 value.
     */
    public String getCustomerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    /**
     * Set the customerProvidedKeySha256 property: The CustomerProvidedKeySha256 property.
     * 
     * @param customerProvidedKeySha256 the customerProvidedKeySha256 value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    /**
     * Get the encryptionScope property: The name of the encryption scope under which the blob is encrypted.
     * 
     * @return the encryptionScope value.
     */
    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    /**
     * Set the encryptionScope property: The name of the encryption scope under which the blob is encrypted.
     * 
     * @param encryptionScope the encryptionScope value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    /**
     * Get the accessTierChangeTime property: The AccessTierChangeTime property.
     * 
     * @return the accessTierChangeTime value.
     */
    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    /**
     * Set the accessTierChangeTime property: The AccessTierChangeTime property.
     * 
     * @param accessTierChangeTime the accessTierChangeTime value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        if (accessTierChangeTime == null) {
            this.accessTierChangeTime = null;
        } else {
            this.accessTierChangeTime = new DateTimeRfc1123(accessTierChangeTime);
        }
        return this;
    }

    /**
     * Get the tagCount property: The TagCount property.
     * 
     * @return the tagCount value.
     */
    public Integer getTagCount() {
        return this.tagCount;
    }

    /**
     * Set the tagCount property: The TagCount property.
     * 
     * @param tagCount the tagCount value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setTagCount(Integer tagCount) {
        this.tagCount = tagCount;
        return this;
    }

    /**
     * Get the expiresOn property: The Expiry-Time property.
     * 
     * @return the expiresOn value.
     */
    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.getDateTime();
    }

    /**
     * Set the expiresOn property: The Expiry-Time property.
     * 
     * @param expiresOn the expiresOn value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setExpiresOn(OffsetDateTime expiresOn) {
        if (expiresOn == null) {
            this.expiresOn = null;
        } else {
            this.expiresOn = new DateTimeRfc1123(expiresOn);
        }
        return this;
    }

    /**
     * Get the isSealed property: The Sealed property.
     * 
     * @return the isSealed value.
     */
    public Boolean isSealed() {
        return this.isSealed;
    }

    /**
     * Set the isSealed property: The Sealed property.
     * 
     * @param isSealed the isSealed value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setIsSealed(Boolean isSealed) {
        this.isSealed = isSealed;
        return this;
    }

    /**
     * Get the lastAccessedOn property: The LastAccessTime property.
     * 
     * @return the lastAccessedOn value.
     */
    public OffsetDateTime getLastAccessedOn() {
        if (this.lastAccessedOn == null) {
            return null;
        }
        return this.lastAccessedOn.getDateTime();
    }

    /**
     * Set the lastAccessedOn property: The LastAccessTime property.
     * 
     * @param lastAccessedOn the lastAccessedOn value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setLastAccessedOn(OffsetDateTime lastAccessedOn) {
        if (lastAccessedOn == null) {
            this.lastAccessedOn = null;
        } else {
            this.lastAccessedOn = new DateTimeRfc1123(lastAccessedOn);
        }
        return this;
    }

    /**
     * Get the deleteTime property: The DeleteTime property.
     * 
     * @return the deleteTime value.
     */
    public OffsetDateTime getDeleteTime() {
        if (this.deleteTime == null) {
            return null;
        }
        return this.deleteTime.getDateTime();
    }

    /**
     * Set the deleteTime property: The DeleteTime property.
     * 
     * @param deleteTime the deleteTime value to set.
     * @return the BlobPropertiesInternal object itself.
     */
    public BlobPropertiesInternal setDeleteTime(OffsetDateTime deleteTime) {
        if (deleteTime == null) {
            this.deleteTime = null;
        } else {
            this.deleteTime = new DateTimeRfc1123(deleteTime);
        }
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Creation-Time", Objects.toString(this.creationTime, null));
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.etag);
        xmlWriter.writeNumberElement("Content-Length", this.contentLength);
        xmlWriter.writeStringElement("Content-Type", this.contentType);
        xmlWriter.writeStringElement("Content-Encoding", this.contentEncoding);
        xmlWriter.writeStringElement("Content-Language", this.contentLanguage);
        xmlWriter.writeBinaryElement("Content-MD5", this.contentMD5);
        xmlWriter.writeStringElement("Content-Disposition", this.contentDisposition);
        xmlWriter.writeStringElement("Cache-Control", this.cacheControl);
        xmlWriter.writeNumberElement("x-ms-blob-sequence-number", this.blobSequenceNumber);
        xmlWriter.writeStringElement("CopyId", this.copyId);
        xmlWriter.writeStringElement("CopySource", this.copySource);
        xmlWriter.writeStringElement("CopyProgress", this.copyProgress);
        xmlWriter.writeStringElement("CopyCompletionTime", Objects.toString(this.copyCompletionTime, null));
        xmlWriter.writeStringElement("CopyStatusDescription", this.copyStatusDescription);
        xmlWriter.writeBooleanElement("ServerEncrypted", this.serverEncrypted);
        xmlWriter.writeBooleanElement("IncrementalCopy", this.incrementalCopy);
        xmlWriter.writeStringElement("DestinationSnapshot", this.destinationSnapshot);
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeBooleanElement("AccessTierInferred", this.accessTierInferred);
        xmlWriter.writeStringElement("CustomerProvidedKeySha256", this.customerProvidedKeySha256);
        xmlWriter.writeStringElement("EncryptionScope", this.encryptionScope);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeNumberElement("TagCount", this.tagCount);
        xmlWriter.writeStringElement("Expiry-Time", Objects.toString(this.expiresOn, null));
        xmlWriter.writeBooleanElement("Sealed", this.isSealed);
        xmlWriter.writeStringElement("LastAccessTime", Objects.toString(this.lastAccessedOn, null));
        xmlWriter.writeStringElement("DeleteTime", Objects.toString(this.deleteTime, null));
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobPropertiesInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobPropertiesInternal if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the BlobPropertiesInternal.
     */
    public static BlobPropertiesInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobPropertiesInternal from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobPropertiesInternal if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the BlobPropertiesInternal.
     */
    public static BlobPropertiesInternal fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobPropertiesInternal deserializedBlobPropertiesInternal = new BlobPropertiesInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Creation-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.creationTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.etag = reader.getStringElement();
                } else if ("Content-Length".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentLength = reader.getNullableElement(Long::parseLong);
                } else if ("Content-Type".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentType = reader.getStringElement();
                } else if ("Content-Encoding".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentEncoding = reader.getStringElement();
                } else if ("Content-Language".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentLanguage = reader.getStringElement();
                } else if ("Content-MD5".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentMD5 = reader.getBinaryElement();
                } else if ("Content-Disposition".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentDisposition = reader.getStringElement();
                } else if ("Cache-Control".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.cacheControl = reader.getStringElement();
                } else if ("x-ms-blob-sequence-number".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.blobSequenceNumber = reader.getNullableElement(Long::parseLong);
                } else if ("CopyId".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyId = reader.getStringElement();
                } else if ("CopySource".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copySource = reader.getStringElement();
                } else if ("CopyProgress".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyProgress = reader.getStringElement();
                } else if ("CopyCompletionTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyCompletionTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("CopyStatusDescription".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyStatusDescription = reader.getStringElement();
                } else if ("ServerEncrypted".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.serverEncrypted
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("IncrementalCopy".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.incrementalCopy
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DestinationSnapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.destinationSnapshot = reader.getStringElement();
                } else if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.remainingRetentionDays
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("AccessTierInferred".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.accessTierInferred
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("CustomerProvidedKeySha256".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.customerProvidedKeySha256 = reader.getStringElement();
                } else if ("EncryptionScope".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.encryptionScope = reader.getStringElement();
                } else if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.accessTierChangeTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("TagCount".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.tagCount = reader.getNullableElement(Integer::parseInt);
                } else if ("Expiry-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.expiresOn = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Sealed".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.isSealed = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("LastAccessTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.lastAccessedOn = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("DeleteTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.deleteTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobPropertiesInternal;
        });
    }
}
