// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for PathSetAccessControlRecursiveMode. */
public enum PathSetAccessControlRecursiveMode {
    /** Enum value set. */
    SET("set"),

    /** Enum value modify. */
    MODIFY("modify"),

    /** Enum value remove. */
    REMOVE("remove");

    /** The actual serialized value for a PathSetAccessControlRecursiveMode instance. */
    private final String value;

    PathSetAccessControlRecursiveMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PathSetAccessControlRecursiveMode instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PathSetAccessControlRecursiveMode object, or null if unable to parse.
     */
    @JsonCreator
    public static PathSetAccessControlRecursiveMode fromString(String value) {
        if (value == null) {
            return null;
        }
        PathSetAccessControlRecursiveMode[] items = PathSetAccessControlRecursiveMode.values();
        for (PathSetAccessControlRecursiveMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
