/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.datalake.implementation.util.AccessorUtility;
import com.azure.storage.file.datalake.models.AccessTier;
import com.azure.storage.file.datalake.models.ArchiveStatus;
import com.azure.storage.file.datalake.models.CopyStatusType;
import com.azure.storage.file.datalake.models.LeaseDurationType;
import com.azure.storage.file.datalake.models.LeaseStateType;
import com.azure.storage.file.datalake.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public class PathProperties {
    private final OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final String eTag;
    private final long fileSize;
    private final String contentType;
    private final byte[] contentMd5;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final String cacheControl;
    private final LeaseStatusType leaseStatus;
    private final LeaseStateType leaseState;
    private final LeaseDurationType leaseDuration;
    private final String copyId;
    private final CopyStatusType copyStatus;
    private final String copySource;
    private final String copyProgress;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final Boolean isServerEncrypted;
    private final Boolean isIncrementalCopy;
    private final AccessTier accessTier;
    private final ArchiveStatus archiveStatus;
    private final String encryptionKeySha256;
    private final OffsetDateTime accessTierChangeTime;
    private final Map<String, String> metadata;
    private final Boolean isDirectory;
    private final OffsetDateTime expiresOn;
    private String encryptionScope;

    public PathProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long fileSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, AccessTier accessTier, ArchiveStatus archiveStatus, String encryptionKeySha256, OffsetDateTime accessTierChangeTime, Map<String, String> metadata) {
        this(creationTime, lastModified, eTag, fileSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, accessTier, archiveStatus, encryptionKeySha256, accessTierChangeTime, metadata, null);
    }

    public PathProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long fileSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, AccessTier accessTier, ArchiveStatus archiveStatus, String encryptionKeySha256, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, OffsetDateTime expiresOn) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.fileSize = fileSize;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.cacheControl = cacheControl;
        this.leaseStatus = leaseStatus;
        this.leaseState = leaseState;
        this.leaseDuration = leaseDuration;
        this.copyId = copyId;
        this.copyStatus = copyStatus;
        this.copySource = copySource;
        this.copyProgress = copyProgress;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.isServerEncrypted = isServerEncrypted;
        this.isIncrementalCopy = isIncrementalCopy;
        this.accessTier = accessTier;
        this.archiveStatus = archiveStatus;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.accessTierChangeTime = accessTierChangeTime;
        this.metadata = metadata;
        this.isDirectory = this.metadata == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(metadata.get("hdi_isfolder")));
        this.expiresOn = expiresOn;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.copyCompletionTime;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    static {
        AccessorUtility.setPathPropertiesAccessor((properties, encryptionScope) -> {
            properties.encryptionScope = encryptionScope;
            return properties;
        });
    }
}

