/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class PathsUpdateHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-properties")
    private String xMsProperties;
    @JsonProperty(value="x-ms-continuation")
    private String xMsContinuation;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="Content-MD5")
    private String contentMD5;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Content-Type")
    private String contentType;

    public PathsUpdateHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.contentRange = rawHeaders.getValue("Content-Range");
        String lastModified = rawHeaders.getValue("Last-Modified");
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsProperties = rawHeaders.getValue("x-ms-properties");
        this.xMsContinuation = rawHeaders.getValue("x-ms-continuation");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.contentMD5 = rawHeaders.getValue("Content-MD5");
        this.acceptRanges = rawHeaders.getValue("Accept-Ranges");
        this.cacheControl = rawHeaders.getValue("Cache-Control");
        this.eTag = rawHeaders.getValue("ETag");
        this.contentDisposition = rawHeaders.getValue("Content-Disposition");
        this.contentEncoding = rawHeaders.getValue("Content-Encoding");
        String contentLength = rawHeaders.getValue("Content-Length");
        if (contentLength != null) {
            this.contentLength = Long.parseLong(contentLength);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.contentLanguage = rawHeaders.getValue("Content-Language");
        this.contentType = rawHeaders.getValue("Content-Type");
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsUpdateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public PathsUpdateHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsUpdateHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsProperties() {
        return this.xMsProperties;
    }

    public PathsUpdateHeaders setXMsProperties(String xMsProperties) {
        this.xMsProperties = xMsProperties;
        return this;
    }

    public String getXMsContinuation() {
        return this.xMsContinuation;
    }

    public PathsUpdateHeaders setXMsContinuation(String xMsContinuation) {
        this.xMsContinuation = xMsContinuation;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsUpdateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public PathsUpdateHeaders setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public PathsUpdateHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public PathsUpdateHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsUpdateHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public PathsUpdateHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public PathsUpdateHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public PathsUpdateHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsUpdateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public PathsUpdateHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PathsUpdateHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

