/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class PathsLeaseHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-lease-time")
    private String xMsLeaseTime;
    @JsonProperty(value="x-ms-lease-id")
    private String xMsLeaseId;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public PathsLeaseHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.eTag = rawHeaders.getValue("ETag");
        this.xMsLeaseTime = rawHeaders.getValue("x-ms-lease-time");
        this.xMsLeaseId = rawHeaders.getValue("x-ms-lease-id");
        String lastModified = rawHeaders.getValue("Last-Modified");
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsLeaseHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsLeaseHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsLeaseTime() {
        return this.xMsLeaseTime;
    }

    public PathsLeaseHeaders setXMsLeaseTime(String xMsLeaseTime) {
        this.xMsLeaseTime = xMsLeaseTime;
        return this;
    }

    public String getXMsLeaseId() {
        return this.xMsLeaseId;
    }

    public PathsLeaseHeaders setXMsLeaseId(String xMsLeaseId) {
        this.xMsLeaseId = xMsLeaseId;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsLeaseHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsLeaseHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsLeaseHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

