/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.util;

import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.DataLakeAclChangeFailedException;
import com.azure.storage.file.datalake.models.DataLakeStorageException;

public class ModelHelper {
    private static final long MAX_APPEND_FILE_BYTES = 0xFA000000L;
    public static final long FILE_DEFAULT_MAX_SINGLE_UPLOAD_SIZE = 0x6400000L;
    private static final long FILE_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000L;
    private static final int FILE_DEFAULT_NUMBER_OF_BUFFERS = 8;

    public static ParallelTransferOptions populateAndApplyDefaults(ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize;
        ParallelTransferOptions parallelTransferOptions = other = other == null ? new ParallelTransferOptions() : other;
        if (other.getBlockSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.blockSize", (long)other.getBlockSizeLong(), (long)1L, (long)0xFA000000L);
        }
        if (other.getMaxSingleUploadSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.maxSingleUploadSize", (long)other.getMaxSingleUploadSizeLong(), (long)1L, (long)0xFA000000L);
        }
        if ((blockSize = other.getBlockSizeLong()) == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x6400000L;
        }
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressReceiver(other.getProgressReceiver()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static DataLakeAclChangeFailedException changeAclRequestFailed(DataLakeStorageException e, String continuationToken) {
        String message = String.format("An error occurred while recursively changing the access control list. See the exception of type %s with status=%s and error code=%s for more information. You can resume changing the access control list using continuationToken=%s after addressing the error.", ((Object)((Object)e)).getClass(), e.getStatusCode(), e.getErrorCode(), continuationToken);
        return new DataLakeAclChangeFailedException(message, e, continuationToken);
    }

    public static DataLakeAclChangeFailedException changeAclFailed(Exception e, String continuationToken) {
        String message = String.format("An error occurred while recursively changing the access control list. See the exception of type %s for more information. You can resume changing the access control list using continuationToken=%s after addressing the error.", e.getClass(), continuationToken);
        return new DataLakeAclChangeFailedException(message, e, continuationToken);
    }
}

