// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for PathLeaseAction. */
public enum PathLeaseAction {
    /** Enum value acquire. */
    ACQUIRE("acquire"),

    /** Enum value break. */
    BREAK("break"),

    /** Enum value change. */
    CHANGE("change"),

    /** Enum value renew. */
    RENEW("renew"),

    /** Enum value release. */
    RELEASE("release");

    /** The actual serialized value for a PathLeaseAction instance. */
    private final String value;

    PathLeaseAction(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PathLeaseAction instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PathLeaseAction object, or null if unable to parse.
     */
    @JsonCreator
    public static PathLeaseAction fromString(String value) {
        PathLeaseAction[] items = PathLeaseAction.values();
        for (PathLeaseAction item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
