/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.sas;

import java.util.Locale;

public final class PathSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;

    public static PathSasPermission parse(String permString) {
        PathSasPermission permissions = new PathSasPermission();
        block7: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block7;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block7;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block7;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block7;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public PathSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public PathSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public PathSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public PathSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public PathSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        return builder.toString();
    }
}

