/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.credentials.SasTokenCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeServiceAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeServiceClient.class, DataLakeServiceAsyncClient.class})
public class DataLakeServiceClientBuilder {
    private final ClientLogger logger = new ClientLogger(DataLakeServiceClientBuilder.class);
    private final BlobServiceClientBuilder blobServiceClientBuilder;
    private String endpoint;
    private String accountName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private SasTokenCredential sasTokenCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> additionalPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private DataLakeServiceVersion version;

    public DataLakeServiceClientBuilder() {
        this.logOptions = DataLakeServiceClientBuilder.getDefaultHttpLogOptions();
        this.blobServiceClientBuilder = new BlobServiceClientBuilder();
    }

    public DataLakeServiceClient buildClient() {
        return new DataLakeServiceClient(this.buildAsyncClient(), this.blobServiceClientBuilder.buildClient());
    }

    public DataLakeServiceAsyncClient buildAsyncClient() {
        if (Objects.isNull(this.storageSharedKeyCredential) && Objects.isNull(this.tokenCredential) && Objects.isNull(this.sasTokenCredential)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Data Lake Service Client cannot be accessed anonymously. Please provide a form of authentication"));
        }
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.sasTokenCredential, this.endpoint, this.retryOptions, this.logOptions, this.httpClient, this.additionalPolicies, this.configuration, this.logger);
        return new DataLakeServiceAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, this.blobServiceClientBuilder.buildAsyncClient());
    }

    public DataLakeServiceClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobServiceClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            BlobUrlParts parts = BlobUrlParts.parse((URL)new URL(endpoint));
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage endpoint url is malformed."));
        }
        return this;
    }

    public DataLakeServiceClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobServiceClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakeServiceClientBuilder credential(TokenCredential credential) {
        this.blobServiceClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakeServiceClientBuilder sasToken(String sasToken) {
        this.blobServiceClientBuilder.sasToken(sasToken);
        this.sasTokenCredential = new SasTokenCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public DataLakeServiceClientBuilder httpClient(HttpClient httpClient) {
        this.blobServiceClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.", new Object[0]);
        }
        this.httpClient = httpClient;
        return this;
    }

    public DataLakeServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobServiceClientBuilder.addPolicy(pipelinePolicy);
        this.additionalPolicies.add(Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null"));
        return this;
    }

    public DataLakeServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobServiceClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public DataLakeServiceClientBuilder configuration(Configuration configuration) {
        this.blobServiceClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakeServiceClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobServiceClientBuilder.retryOptions(retryOptions);
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public DataLakeServiceClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobServiceClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.", new Object[0]);
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DataLakeServiceClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobServiceClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }
}

