/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class DataLakeDirectoryAsyncClient
extends DataLakePathAsyncClient {
    private final ClientLogger logger = new ClientLogger(DataLakeDirectoryAsyncClient.class);

    DataLakeDirectoryAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String directoryName, BlockBlobAsyncClient blockBlobAsyncClient) {
        super(pipeline, url, serviceVersion, accountName, fileSystemName, directoryName, PathResourceType.DIRECTORY, blockBlobAsyncClient);
    }

    DataLakeDirectoryAsyncClient(DataLakePathAsyncClient dataLakePathAsyncClient) {
        super(dataLakePathAsyncClient.getHttpPipeline(), dataLakePathAsyncClient.getPathUrl(), dataLakePathAsyncClient.getServiceVersion(), dataLakePathAsyncClient.getAccountName(), dataLakePathAsyncClient.getFileSystemName(), dataLakePathAsyncClient.getObjectPath(), PathResourceType.DIRECTORY, dataLakePathAsyncClient.getBlockBlobAsyncClient());
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(false, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(recursive, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public DataLakeFileAsyncClient getFileAsyncClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.prepareBuilderAppendPath(fileName).buildBlockBlobAsyncClient();
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), StorageImplUtils.appendToUrlPath((String)this.getPathUrl(), (String)Utility.urlEncode((String)Utility.urlDecode((String)fileName))).toString(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath() + "/" + Utility.urlDecode((String)fileName), blockBlobAsyncClient);
    }

    public Mono<DataLakeFileAsyncClient> createFile(String fileName) {
        try {
            return this.createFileWithResponse(fileName, null, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeFileAsyncClient dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
            return dataLakeFileAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeFileAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions) {
        try {
            return this.getFileAsyncClient(fileName).deleteWithResponse(requestConditions);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public DataLakeDirectoryAsyncClient getSubdirectoryAsyncClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.prepareBuilderAppendPath(subdirectoryName).buildBlockBlobAsyncClient();
        return new DataLakeDirectoryAsyncClient(this.getHttpPipeline(), StorageImplUtils.appendToUrlPath((String)this.getPathUrl(), (String)Utility.urlEncode((String)Utility.urlDecode((String)subdirectoryName))).toString(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath() + "/" + Utility.urlDecode((String)subdirectoryName), blockBlobAsyncClient);
    }

    public Mono<DataLakeDirectoryAsyncClient> createSubdirectory(String subdirectoryName) {
        try {
            return this.createSubdirectoryWithResponse(subdirectoryName, null, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DataLakeDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient = this.getSubdirectoryAsyncClient(subdirectoryName);
            return dataLakeDirectoryAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeDirectoryAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> deleteSubdirectory(String subdirectoryName) {
        try {
            return this.deleteSubdirectoryWithResponse(subdirectoryName, false, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteSubdirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions) {
        try {
            return this.getSubdirectoryAsyncClient(directoryName).deleteWithResponse(recursive, requestConditions);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<DataLakeDirectoryAsyncClient> rename(String destinationFileSystem, String destinationPath) {
        try {
            return this.renameWithResponse(destinationFileSystem, destinationPath, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DataLakeDirectoryAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, (Context)context)).map(response -> new SimpleResponse(response, (Object)new DataLakeDirectoryAsyncClient((DataLakePathAsyncClient)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    SpecializedBlobClientBuilder prepareBuilderAppendPath(String pathName) {
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(StorageImplUtils.appendToUrlPath((String)blobUrl, (String)pathName).toString());
    }
}

