/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;
import reactor.core.publisher.Mono;

public class MetadataValidationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(MetadataValidationPolicy.class);
    private static final int X_MS_META_LENGTH = "x-ms-meta".length();

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            context.getHttpRequest().getHeaders().stream().filter(header -> header.getName().toLowerCase(Locale.ROOT).startsWith("x-ms-meta")).forEach(header -> {
                boolean foundWhitespace;
                String name = header.getName();
                String value = header.getValue();
                boolean bl = foundWhitespace = Character.isWhitespace(name.charAt(X_MS_META_LENGTH)) || Character.isWhitespace(name.charAt(name.length() - 1)) || Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1));
                if (foundWhitespace) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Metadata keys and values can not contain leading or trailing whitespace. Please remove or encode them."));
                }
            });
        }
        catch (IllegalArgumentException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
        return next.process();
    }
}

