/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.UrlBuilder;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RequestRetryPolicy
implements HttpPipelinePolicy {
    private final RequestRetryOptions requestRetryOptions;

    public RequestRetryPolicy(RequestRetryOptions requestRetryOptions) {
        this.requestRetryOptions = requestRetryOptions;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        boolean considerSecondary = this.requestRetryOptions.getSecondaryHost() != null && (HttpMethod.GET.equals((Object)context.getHttpRequest().getHttpMethod()) || HttpMethod.HEAD.equals((Object)context.getHttpRequest().getHttpMethod()));
        return this.attemptAsync(context, next, context.getHttpRequest(), considerSecondary, 1, 1);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalRequest, boolean considerSecondary, int primaryTry, int attempt) {
        boolean tryingPrimary = !considerSecondary || attempt % 2 != 0;
        long delayMs = tryingPrimary ? this.requestRetryOptions.calculateDelayInMs(primaryTry) : (long)(((double)(ThreadLocalRandom.current().nextFloat() / 2.0f) + 0.8) * 1000.0);
        context.setHttpRequest(originalRequest.copy());
        Flux bufferedBody = context.getHttpRequest().getBody() == null ? null : context.getHttpRequest().getBody().map(ByteBuffer::duplicate);
        context.getHttpRequest().setBody(bufferedBody);
        if (!tryingPrimary) {
            UrlBuilder builder = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
            builder.setHost(this.requestRetryOptions.getSecondaryHost());
            try {
                context.getHttpRequest().setUrl(builder.toUrl());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        context.setData("requestRetryCount", (Object)(attempt + 1));
        return next.clone().process().timeout(this.requestRetryOptions.getTryTimeoutDuration()).delaySubscription(Duration.ofMillis(delayMs)).flatMap(response -> {
            String action;
            boolean newConsiderSecondary = considerSecondary;
            int statusCode = response.getStatusCode();
            if (!tryingPrimary && statusCode == 404) {
                newConsiderSecondary = false;
                action = "Retry: Secondary URL returned 404";
            } else {
                action = statusCode == 503 || statusCode == 500 ? "Retry: Temporary error or server timeout" : "NoRetry: Successful HTTP request";
            }
            if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.getMaxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                Flux responseBody = response.getBody();
                if (responseBody == null) {
                    return this.attemptAsync(context, next, originalRequest, newConsiderSecondary, newPrimaryTry, attempt + 1);
                }
                return response.getBody().ignoreElements().then(this.attemptAsync(context, next, originalRequest, newConsiderSecondary, newPrimaryTry, attempt + 1));
            }
            return Mono.just((Object)response);
        }).onErrorResume(throwable -> {
            if (throwable instanceof IllegalStateException && attempt > 1) {
                return Mono.error((Throwable)new IllegalStateException("The request failed because the size of the contents of the provided Flux did not match the provided data size upon attempting to retry. This is likely caused by the Flux not being replayable. To support retries, all Fluxes must produce the same data for each subscriber. Please ensure this behavior.", (Throwable)throwable));
            }
            String action = throwable instanceof IOException ? "Retry: Network error" : (throwable instanceof TimeoutException ? "Retry: Client timeout" : "NoRetry: Unknown error");
            if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.getMaxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                return this.attemptAsync(context, next, originalRequest, considerSecondary, newPrimaryTry, attempt + 1);
            }
            return Mono.error((Throwable)throwable);
        });
    }
}

