/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasPermission;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;

public class AccountSasImplUtil {
    private final ClientLogger logger = new ClientLogger(AccountSasImplUtil.class);
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String services;
    private String resourceTypes;

    public AccountSasImplUtil(AccountSasSignatureValues sasValues) {
        this.version = sasValues.getVersion();
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.services = sasValues.getServices();
        this.resourceTypes = sasValues.getResourceTypes();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        StorageImplUtils.assertNotNull("storageSharedKeyCredentials", storageSharedKeyCredentials);
        StorageImplUtils.assertNotNull("services", this.services);
        StorageImplUtils.assertNotNull("resourceTypes", this.resourceTypes);
        StorageImplUtils.assertNotNull("expiryTime", this.expiryTime);
        StorageImplUtils.assertNotNull("permissions", this.permissions);
        if (CoreUtils.isNullOrEmpty((CharSequence)this.version)) {
            this.version = "2020-04-08";
        }
        String stringToSign = this.stringToSign(storageSharedKeyCredentials);
        StorageImplUtils.logStringToSign(this.logger, stringToSign, context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return this.encode(signature);
    }

    private String stringToSign(StorageSharedKeyCredential storageSharedKeyCredentials) {
        return String.join((CharSequence)"\n", storageSharedKeyCredentials.getAccountName(), AccountSasPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter(sb, "sv", this.version);
        SasImplUtils.tryAppendQueryParameter(sb, "ss", this.services);
        SasImplUtils.tryAppendQueryParameter(sb, "srt", this.resourceTypes);
        SasImplUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter(sb, "st", SasImplUtils.formatQueryParameterDate(this.startTime));
        SasImplUtils.tryAppendQueryParameter(sb, "se", SasImplUtils.formatQueryParameterDate(this.expiryTime));
        SasImplUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        SasImplUtils.tryAppendQueryParameter(sb, "sig", signature);
        return sb.toString();
    }
}

