/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobQueryHeaders;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import com.azure.storage.blob.options.BlobCopyFromUrlOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobGetTagsOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobSetAccessTierOptions;
import com.azure.storage.blob.options.BlobSetTagsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.common.implementation.FluxInputStream;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobClientBase {
    private final ClientLogger logger = new ClientLogger(BlobClientBase.class);
    private final BlobAsyncClientBase client;

    protected BlobClientBase(BlobAsyncClientBase client) {
        this.client = client;
    }

    public BlobClientBase getSnapshotClient(String snapshot) {
        return new BlobClientBase(this.client.getSnapshotClient(snapshot));
    }

    public BlobClientBase getVersionClient(String versionId) {
        return new BlobClientBase(this.client.getVersionClient(versionId));
    }

    public String getBlobUrl() {
        return this.client.getBlobUrl();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public final String getContainerName() {
        return this.client.getContainerName();
    }

    public final String getBlobName() {
        return this.client.getBlobName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.client.getCustomerProvidedKey();
    }

    String getEncryptionScope() {
        return this.client.getEncryptionScope();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public String getSnapshotId() {
        return this.client.getSnapshotId();
    }

    public String getVersionId() {
        return this.client.getVersionId();
    }

    public boolean isSnapshot() {
        return this.client.isSnapshot();
    }

    public final BlobInputStream openInputStream() {
        return this.openInputStream(null, null);
    }

    public final BlobInputStream openInputStream(BlobRange range, BlobRequestConditions requestConditions) {
        return this.openInputStream(new BlobInputStreamOptions().setRange(range).setRequestConditions(requestConditions));
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options) {
        BlobRequestConditions requestConditions;
        options = options == null ? new BlobInputStreamOptions() : options;
        BlobProperties properties = this.getProperties();
        BlobRange range = options.getRange() == null ? new BlobRange(0L) : options.getRange();
        int chunkSize = options.getBlockSize() == null ? 0x400000 : options.getBlockSize();
        BlobRequestConditions blobRequestConditions = requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        if (requestConditions.getIfMatch() == null) {
            requestConditions.setIfMatch(properties.getETag());
        }
        return new BlobInputStream(this.client, range.getOffset(), range.getCount(), chunkSize, requestConditions, properties);
    }

    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, pollInterval);
    }

    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration pollInterval) {
        return this.beginCopy(new BlobBeginCopyOptions(sourceUrl).setMetadata(metadata).setTier(tier).setRehydratePriority(priority).setSourceRequestConditions(ModelHelper.populateBlobSourceRequestConditions(sourceModifiedRequestConditions)).setDestinationRequestConditions(destRequestConditions).setPollInterval(pollInterval));
    }

    public SyncPoller<BlobCopyInfo, Void> beginCopy(BlobBeginCopyOptions options) {
        return this.client.beginCopy(options).getSyncPoller();
    }

    public void abortCopyFromUrl(String copyId) {
        this.abortCopyFromUrlWithResponse(copyId, null, null, Context.NONE);
    }

    public Response<Void> abortCopyFromUrlWithResponse(String copyId, String leaseId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.abortCopyFromUrlWithResponse(copyId, leaseId, context), (Duration)timeout);
    }

    public String copyFromUrl(String copySource) {
        return (String)this.copyFromUrlWithResponse(copySource, null, null, null, null, null, Context.NONE).getValue();
    }

    public Response<String> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration timeout, Context context) {
        return this.copyFromUrlWithResponse(new BlobCopyFromUrlOptions(copySource).setMetadata(metadata).setTier(tier).setSourceRequestConditions(sourceModifiedRequestConditions).setDestinationRequestConditions(destRequestConditions), timeout, context);
    }

    public Response<String> copyFromUrlWithResponse(BlobCopyFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<String>> response = this.client.copyFromUrlWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void download(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    public BlobDownloadResponse downloadWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"stream", (Object)stream);
        Mono download = this.client.downloadWithResponse(range, options, requestConditions, getRangeContentMd5, context).flatMap(response -> ((Flux)response.getValue()).reduce((Object)stream, (outputStream, buffer) -> {
            try {
                outputStream.write(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
                return outputStream;
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(ex)));
            }
        }).thenReturn((Object)new BlobDownloadResponse((BlobDownloadAsyncResponse)((Object)response))));
        return (BlobDownloadResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    public BlobProperties downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    public BlobProperties downloadToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return (BlobProperties)this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, null, timeout, context);
    }

    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions(ModelHelper.populateAndApplyDefaults(parallelTransferOptions));
        return this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(downloadRetryOptions).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
    }

    public Response<BlobProperties> downloadToFileWithResponse(BlobDownloadToFileOptions options, Duration timeout, Context context) {
        Mono<Response<BlobProperties>> download = this.client.downloadToFileWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(download, (Duration)timeout);
    }

    public void delete() {
        this.deleteWithResponse(null, null, null, Context.NONE);
    }

    public Response<Void> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public BlobProperties getProperties() {
        return (BlobProperties)this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    public Response<BlobProperties> getPropertiesWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<BlobProperties>> response = this.client.getPropertiesWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void setHttpHeaders(BlobHttpHeaders headers) {
        this.setHttpHeadersWithResponse(headers, null, null, Context.NONE);
    }

    public Response<Void> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setHttpHeadersWithResponse(headers, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public Map<String, String> getTags() {
        return (Map)this.getTagsWithResponse(new BlobGetTagsOptions(), null, Context.NONE).getValue();
    }

    public Response<Map<String, String>> getTagsWithResponse(BlobGetTagsOptions options, Duration timeout, Context context) {
        Mono<Response<Map<String, String>>> response = this.client.getTagsWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void setTags(Map<String, String> tags) {
        this.setTagsWithResponse(new BlobSetTagsOptions(tags), null, Context.NONE);
    }

    public Response<Void> setTagsWithResponse(BlobSetTagsOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setTagsWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public BlobClientBase createSnapshot() {
        return (BlobClientBase)this.createSnapshotWithResponse(null, null, null, Context.NONE).getValue();
    }

    public Response<BlobClientBase> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono response = this.client.createSnapshotWithResponse(metadata, requestConditions, context).map(rb -> new SimpleResponse(rb, (Object)new BlobClientBase((BlobAsyncClientBase)rb.getValue())));
        return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)response, (Duration)timeout);
    }

    public void setAccessTier(AccessTier tier) {
        this.setAccessTierWithResponse(tier, null, null, null, Context.NONE);
    }

    public Response<Void> setAccessTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId, Duration timeout, Context context) {
        return this.setAccessTierWithResponse(new BlobSetAccessTierOptions(tier).setPriority(priority).setLeaseId(leaseId), timeout, context);
    }

    public Response<Void> setAccessTierWithResponse(BlobSetAccessTierOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.setTierWithResponse(options, context), (Duration)timeout);
    }

    public void undelete() {
        this.undeleteWithResponse(null, Context.NONE);
    }

    public Response<Void> undeleteWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.undeleteWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public StorageAccountInfo getAccountInfo() {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(null, Context.NONE).getValue();
    }

    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Mono<Response<StorageAccountInfo>> response = this.client.getAccountInfoWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.client.generateSas(blobServiceSasSignatureValues);
    }

    public InputStream openQueryInputStream(String expression) {
        return (InputStream)this.openQueryInputStreamWithResponse(new BlobQueryOptions(expression)).getValue();
    }

    public Response<InputStream> openQueryInputStreamWithResponse(BlobQueryOptions queryOptions) {
        BlobQueryAsyncResponse response = (BlobQueryAsyncResponse)((Object)this.client.queryWithResponse(queryOptions).block());
        if (response == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Query response cannot be null"));
        }
        return new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new FluxInputStream((Flux)response.getValue()), (Object)((BlobQueryHeaders)response.getDeserializedHeaders()));
    }

    public void query(OutputStream stream, String expression) {
        this.queryWithResponse(new BlobQueryOptions(expression, stream), null, Context.NONE);
    }

    public BlobQueryResponse queryWithResponse(BlobQueryOptions queryOptions, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)queryOptions);
        StorageImplUtils.assertNotNull((String)"outputStream", (Object)queryOptions.getOutputStream());
        Mono download = this.client.queryWithResponse(queryOptions, context).flatMap(response -> ((Flux)response.getValue()).reduce((Object)queryOptions.getOutputStream(), (outputStream, buffer) -> {
            try {
                outputStream.write(FluxUtil.byteBufferToArray((ByteBuffer)buffer));
                return outputStream;
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new UncheckedIOException(ex)));
            }
        }).thenReturn((Object)new BlobQueryResponse((BlobQueryAsyncResponse)((Object)response))));
        return (BlobQueryResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }
}

