// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * Represents a single block in a block blob.  It describes the block's ID and
 * size.
 */
@JacksonXmlRootElement(localName = "Block")
@Fluent
public final class Block {
    /*
     * The base64 encoded block ID.
     */
    @JsonProperty(value = "Name", required = true)
    private String name;

    /*
     * The block size in bytes.
     */
    @JsonProperty(value = "Size", required = true)
    private long sizeLong;

    /**
     * Get the name property: The base64 encoded block ID.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The base64 encoded block ID.
     *
     * @param name the name value to set.
     * @return the Block object itself.
     */
    public Block setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the sizeLong property: The block size in bytes.
     *
     * @return the sizeLong value.
     */
    public long getSizeLong() {
        return this.sizeLong;
    }

    /**
     * Set the sizeLong property: The block size in bytes.
     *
     * @param sizeLong the sizeLong value to set.
     * @return the Block object itself.
     */
    public Block setSizeLong(long sizeLong) {
        this.sizeLong = sizeLong;
        return this;
    }

    /**
     * Get the size property: The size property.
     *
     * @return the size value.
     * @deprecated Use {@link #getSizeLong()}
     */
    @Deprecated  public int getSize() {
        return (int) this.sizeLong;
    }

    /**
     * Set the size property: The size property.
     *
     * @param size the size value to set.
     * @deprecated Use {@link #setSizeLong(long)}
     * @return the Block object itself.
     */
    @Deprecated public Block setSize(int size) {
        this.sizeLong = size;
        return this;
    }
}
