/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobClearPagesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobCopyIncrementalHeaders;
import com.azure.storage.blob.implementation.models.PageBlobCreateHeaders;
import com.azure.storage.blob.implementation.models.PageBlobResizeHeaders;
import com.azure.storage.blob.implementation.models.PageBlobUpdateSequenceNumberHeaders;
import com.azure.storage.blob.implementation.models.PageBlobUploadPagesFromURLHeaders;
import com.azure.storage.blob.implementation.models.PageBlobUploadPagesHeaders;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PageBlobAsyncClient
extends BlobAsyncClientBase {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;
    private final ClientLogger logger = new ClientLogger(PageBlobAsyncClient.class);

    PageBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope);
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.getStart() < 0L || pageRange.getEnd() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.getStart() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.getEnd() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.getEnd() <= pageRange.getStart()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.getStart() + '-' + pageRange.getEnd();
    }

    public Mono<PageBlobItem> create(long size) {
        try {
            return this.create(size, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PageBlobItem> create(long size, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.createWithResponse(size, null, null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(size, sequenceNumber, headers, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (size % 512L != 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        return this.azureBlobStorage.pageBlobs().createWithRestResponseAsync(null, null, 0L, size, null, null, metadata, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), sequenceNumber, null, headers, this.getCustomerProvidedKey(), this.encryptionScope, context).map(rb -> {
            PageBlobCreateHeaders hd = (PageBlobCreateHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), null);
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<PageBlobItem> uploadPages(PageRange pageRange, Flux<ByteBuffer> body) {
        try {
            return this.uploadPagesWithResponse(pageRange, body, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesWithResponse(pageRange, body, contentMd5, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        return this.azureBlobStorage.pageBlobs().uploadPagesWithRestResponseAsync(null, null, body, pageRange.getEnd() - pageRange.getStart() + 1L, contentMd5, null, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context).map(rb -> {
            PageBlobUploadPagesHeaders hd = (PageBlobUploadPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), hd.getBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<PageBlobItem> uploadPagesFromUrl(PageRange range, String sourceUrl, Long sourceOffset) {
        try {
            return this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, sourceContentMd5, destRequestConditions, sourceRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Context context) {
        URL url;
        if (range == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("range cannot be null."));
        }
        String rangeString = PageBlobAsyncClient.pageRangeToString(range);
        if (sourceOffset == null) {
            sourceOffset = 0L;
        }
        String sourceRangeString = PageBlobAsyncClient.pageRangeToString(new PageRange().setStart(sourceOffset).setEnd(sourceOffset + (range.getEnd() - range.getStart())));
        destRequestConditions = destRequestConditions == null ? new PageBlobRequestConditions() : destRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new BlobRequestConditions() : sourceRequestConditions;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        return this.azureBlobStorage.pageBlobs().uploadPagesFromURLWithRestResponseAsync(null, null, url, sourceRangeString, 0L, rangeString, sourceContentMd5, null, null, destRequestConditions.getLeaseId(), destRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), destRequestConditions.getIfSequenceNumberLessThan(), destRequestConditions.getIfSequenceNumberEqualTo(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context).map(rb -> {
            PageBlobUploadPagesFromURLHeaders hd = (PageBlobUploadPagesFromURLHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), hd.getEncryptionScope(), null);
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<PageBlobItem> clearPages(PageRange pageRange) {
        try {
            return this.clearPagesWithResponse(pageRange, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.clearPagesWithResponse(pageRange, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        return this.azureBlobStorage.pageBlobs().clearPagesWithRestResponseAsync(null, null, 0L, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context).map(rb -> {
            PageBlobClearPagesHeaders hd = (PageBlobClearPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isServerEncrypted(), hd.getEncryptionKeySha256(), null, hd.getBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<PageList> getPageRanges(BlobRange blobRange) {
        try {
            return this.getPageRangesWithResponse(blobRange, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesWithResponse(blobRange, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.pageBlobs().getPageRangesWithRestResponseAsync(null, null, this.getSnapshotId(), null, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, context).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public Mono<PageList> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        try {
            return this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PageList> getManagedDiskPageRangesDiff(BlobRange blobRange, String prevSnapshotUrl) {
        try {
            return this.getManagedDiskPageRangesDiffWithResponse(blobRange, prevSnapshotUrl, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageList>> getManagedDiskPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshotUrl, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, null, prevSnapshotUrl, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, String prevSnapshotUrl, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        URL url = null;
        if (prevSnapshotUrl == null && prevSnapshot == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("prevSnapshot cannot be null"));
        }
        if (prevSnapshotUrl != null) {
            try {
                url = new URL(prevSnapshotUrl);
            }
            catch (MalformedURLException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'prevSnapshotUrl' is not a valid url."));
            }
        }
        return this.azureBlobStorage.pageBlobs().getPageRangesDiffWithRestResponseAsync(null, null, this.getSnapshotId(), null, prevSnapshot, url, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, context).map(response -> new SimpleResponse((Response)response, (Object)response.getValue()));
    }

    public Mono<PageBlobItem> resize(long size) {
        try {
            return this.resizeWithResponse(size, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.resizeWithResponse(size, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions, Context context) {
        if (size % 512L != 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.pageBlobs().resizeWithRestResponseAsync(null, null, size, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context).map(rb -> {
            PageBlobResizeHeaders hd = (PageBlobResizeHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<PageBlobItem> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        try {
            return this.updateSequenceNumberWithResponse(action, sequenceNumber, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.updateSequenceNumberWithResponse(action, sequenceNumber, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions, Context context) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        sequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        return this.azureBlobStorage.pageBlobs().updateSequenceNumberWithRestResponseAsync(null, null, action, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), sequenceNumber, null, context).map(rb -> {
            PageBlobUpdateSequenceNumberHeaders hd = (PageBlobUpdateSequenceNumberHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getBlobSequenceNumber());
            return new SimpleResponse((Response)rb, (Object)item);
        });
    }

    public Mono<CopyStatusType> copyIncremental(String source, String snapshot) {
        try {
            return this.copyIncrementalWithResponse(source, snapshot, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<CopyStatusType>> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.copyIncrementalWithResponse(source, snapshot, modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CopyStatusType>> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions, Context context) {
        URL url;
        UrlBuilder builder = UrlBuilder.parse((String)source);
        builder.setQueryParameter("snapshot", snapshot);
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        try {
            url = builder.toUrl();
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(e));
        }
        return this.azureBlobStorage.pageBlobs().copyIncrementalWithRestResponseAsync(null, null, url, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((PageBlobCopyIncrementalHeaders)rb.getDeserializedHeaders()).getCopyStatus()));
    }
}

