/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import reactor.core.publisher.Flux;

final class UploadBufferPool {
    private final ClientLogger logger = new ClientLogger(UploadBufferPool.class);
    private final BlockingQueue<ByteBuffer> buffers;
    private final int maxBuffs;
    private int numBuffs;
    private final int buffSize;
    private ByteBuffer currentBuf;

    UploadBufferPool(int numBuffs, int buffSize) {
        StorageImplUtils.assertInBounds((String)"numBuffs", (long)numBuffs, (long)2L, (long)Integer.MAX_VALUE);
        this.maxBuffs = numBuffs;
        this.buffers = new LinkedBlockingQueue<ByteBuffer>(numBuffs);
        StorageImplUtils.assertInBounds((String)"buffSize", (long)buffSize, (long)1L, (long)0x6400000L);
        this.buffSize = buffSize;
        this.buffers.add(ByteBuffer.allocate(this.buffSize));
        this.buffers.add(ByteBuffer.allocate(this.buffSize));
        this.numBuffs = 2;
    }

    public Flux<ByteBuffer> write(ByteBuffer buf) {
        Flux result;
        if (this.currentBuf == null) {
            this.currentBuf = this.getBuffer();
        }
        if (this.currentBuf.remaining() >= buf.remaining()) {
            this.currentBuf.put(buf);
            if (this.currentBuf.remaining() == 0) {
                this.currentBuf.position(0);
                result = Flux.just((Object)this.currentBuf);
                this.currentBuf = null;
            } else {
                result = Flux.empty();
            }
        } else {
            int oldLimit = buf.limit();
            buf.limit(buf.position() + this.currentBuf.remaining());
            this.currentBuf.put(buf);
            buf.limit(oldLimit);
            this.currentBuf.position(0);
            result = Flux.just((Object)this.currentBuf);
            this.currentBuf = this.getBuffer();
            this.currentBuf.put(buf);
        }
        return result;
    }

    private ByteBuffer getBuffer() {
        ByteBuffer result;
        if (this.buffers.isEmpty() && this.numBuffs < this.maxBuffs) {
            result = ByteBuffer.allocate(this.buffSize);
            ++this.numBuffs;
        } else {
            try {
                result = this.buffers.take();
            }
            catch (InterruptedException e) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("BufferedUpload thread interrupted. Thread:" + Thread.currentThread().getId()));
            }
        }
        return result;
    }

    Flux<ByteBuffer> flush() {
        if (this.currentBuf != null) {
            this.currentBuf.flip();
            ByteBuffer last = this.currentBuf;
            this.currentBuf = null;
            return Flux.just((Object)last);
        }
        return Flux.empty();
    }

    void returnBuffer(ByteBuffer b) {
        b.position(0);
        b.limit(b.capacity());
        try {
            this.buffers.put(b);
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("UploadFromStream thread interrupted."));
        }
    }
}

