/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.implementation.accesshelpers.BlobItemConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobHierarchyListSegment;
import com.azure.storage.blob.implementation.models.BlobSignedIdentifierWrapper;
import com.azure.storage.blob.implementation.models.ContainersFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.ListBlobsFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.options.FindBlobsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=BlobContainerClientBuilder.class)
public final class BlobContainerClient {
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";
    private static final ClientLogger LOGGER = new ClientLogger(BlobContainerClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final String containerName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;

    BlobContainerClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        try {
            URI.create(this.getBlobContainerUrl());
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
    }

    public BlobClient getBlobClient(String blobName) {
        return this.getBlobClient(blobName, null);
    }

    public BlobClient getBlobClient(String blobName, String snapshot) {
        return new BlobClient(new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, snapshot, this.getCustomerProvidedKey(), this.encryptionScope));
    }

    public BlobClient getBlobVersionClient(String blobName, String versionId) {
        return new BlobClient(new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, null, this.getCustomerProvidedKey(), this.encryptionScope, versionId));
    }

    public String getBlobContainerName() {
        return this.containerName;
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    public String getBlobContainerUrl() {
        return this.azureBlobStorage.getUrl() + "/" + Utility.urlEncode((String)this.containerName);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public BlobServiceClient getServiceClient() {
        CustomerProvidedKey encryptionKey = this.customerProvidedKey == null ? null : new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
        return new BlobServiceClientBuilder().endpoint(this.getBlobContainerUrl()).pipeline(this.getHttpPipeline()).serviceVersion(this.serviceVersion).blobContainerEncryptionScope(this.blobContainerEncryptionScope).encryptionScope(this.getEncryptionScope()).customerProvidedKey(encryptionKey).buildClient();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Response<BlobContainerProperties> response = this.getPropertiesWithResponse(null, timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (RuntimeException e) {
            if (e instanceof BlobStorageException && ((BlobStorageException)((Object)e)).getResponse().getStatusCode() == 404) {
                HttpResponse response = ((BlobStorageException)((Object)e)).getResponse();
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getContainers().createNoCustomHeadersWithResponse(this.containerName, null, metadata, accessType, null, this.blobContainerEncryptionScope, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean createIfNotExists() {
        return (Boolean)this.createIfNotExistsWithResponse(null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> createIfNotExistsWithResponse(BlobContainerCreateOptions options, Duration timeout, Context context) {
        BlobContainerCreateOptions finalOptions = options == null ? new BlobContainerCreateOptions() : options;
        try {
            Response<Void> response = this.createWithResponse(finalOptions.getMetadata(), finalOptions.getPublicAccessType(), timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 409) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions;
        BlobRequestConditions blobRequestConditions = finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(requestConditions)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getContainers().deleteNoCustomHeadersWithResponse(this.containerName, null, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(requestConditions, timeout, context);
            return new SimpleResponse(response, (Object)true);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerProperties getProperties() {
        return (BlobContainerProperties)this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerProperties> getPropertiesWithResponse(String leaseId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().getPropertiesWithResponse(this.containerName, null, leaseId, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        ContainersGetPropertiesHeaders hd = (ContainersGetPropertiesHeaders)response.getDeserializedHeaders();
        BlobContainerProperties properties = new BlobContainerProperties(hd.getXMsMeta(), hd.getETag(), hd.getLastModified(), hd.getXMsLeaseDuration(), hd.getXMsLeaseState(), hd.getXMsLeaseStatus(), hd.getXMsBlobPublicAccess(), Boolean.TRUE.equals(hd.isXMsHasImmutabilityPolicy()), Boolean.TRUE.equals(hd.isXMsHasLegalHold()), hd.getXMsDefaultEncryptionScope(), hd.isXMsDenyEncryptionScopeOverride(), hd.isXMsImmutableStorageWithVersioningEnabled());
        return new SimpleResponse((Response)response, (Object)properties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        BlobRequestConditions blobRequestConditions = finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(finalRequestConditions) || finalRequestConditions.getIfUnmodifiedSince() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("If-Modified-Since is the only HTTP access condition supported for this API"));
        }
        Callable<Response> operation = () -> this.azureBlobStorage.getContainers().setMetadataWithResponse(this.containerName, null, finalRequestConditions.getLeaseId(), metadata, finalRequestConditions.getIfModifiedSince(), null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerAccessPolicies getAccessPolicy() {
        return (BlobContainerAccessPolicies)this.getAccessPolicyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerAccessPolicies> getAccessPolicyWithResponse(String leaseId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().getAccessPolicyWithResponse(this.containerName, null, leaseId, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)new BlobContainerAccessPolicies(((ContainersGetAccessPolicyHeaders)response.getDeserializedHeaders()).getXMsBlobPublicAccess(), ((BlobSignedIdentifierWrapper)response.getValue()).items()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers) {
        this.setAccessPolicyWithResponse(accessType, identifiers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions;
        BlobRequestConditions blobRequestConditions = finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(requestConditions)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        List<BlobSignedIdentifier> finalIdentifiers = ModelHelper.truncateTimeForBlobSignedIdentifier(identifiers);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getContainers().setAccessPolicyNoCustomHeadersWithResponse(this.containerName, null, finalRequestConditions.getLeaseId(), accessType, finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), null, finalIdentifiers, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs() {
        return this.listBlobs(new ListBlobsOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, Duration timeout) {
        return this.listBlobs(options, null, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, String continuationToken, Duration timeout) {
        BiFunction<String, Integer, PagedResponse> retriever = (nextMarker, pageSize) -> {
            ListBlobsOptions finalOptions = new ListBlobsOptions();
            if (options != null) {
                finalOptions.setMaxResultsPerPage(options.getMaxResultsPerPage()).setPrefix(options.getPrefix()).setStartFrom(options.getStartFrom()).setDetails(options.getDetails());
            }
            if (pageSize != null) {
                finalOptions.setMaxResultsPerPage((Integer)pageSize);
            }
            ArrayList<ListBlobsIncludeItem> include = finalOptions.getDetails().toList().isEmpty() ? null : finalOptions.getDetails().toList();
            Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().listBlobFlatSegmentWithResponse(this.containerName, finalOptions.getPrefix(), (String)nextMarker, finalOptions.getMaxResultsPerPage(), (List<ListBlobsIncludeItem>)include, finalOptions.getStartFrom(), null, null, Context.NONE);
            ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
            List value = ((ListBlobsFlatSegmentResponse)response.getValue()).getSegment() == null ? Collections.emptyList() : ((ListBlobsFlatSegmentResponse)response.getValue()).getSegment().getBlobItems().stream().map(ModelHelper::populateBlobItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((ListBlobsFlatSegmentResponse)response.getValue()).getNextMarker(), (Object)((ContainersListBlobFlatSegmentHeaders)response.getDeserializedHeaders()));
        };
        return new PagedIterable(pageSize -> (PagedResponse)retriever.apply(continuationToken, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobsByHierarchy(String directory) {
        return this.listBlobsByHierarchy("/", new ListBlobsOptions().setPrefix(directory), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobItem> listBlobsByHierarchy(String delimiter, ListBlobsOptions options, Duration timeout) {
        BiFunction<String, Integer, PagedResponse> func = (marker, pageSize) -> {
            ListBlobsOptions finalOptions = new ListBlobsOptions();
            if (options != null) {
                finalOptions.setMaxResultsPerPage(options.getMaxResultsPerPage()).setPrefix(options.getPrefix()).setDetails(options.getDetails()).setStartFrom(options.getStartFrom());
            }
            if (pageSize != null) {
                finalOptions.setMaxResultsPerPage((Integer)pageSize);
            }
            return this.listBlobsHierarchySegment((String)marker, delimiter, finalOptions, timeout);
        };
        return new PagedIterable(pageSize -> (PagedResponse)func.apply((String)null, (Integer)pageSize), func);
    }

    private PagedResponse<BlobItem> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options, Duration timeout) {
        if (options.getDetails().getRetrieveSnapshots()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Including snapshots in a hierarchical listing is not supported."));
        }
        ArrayList<ListBlobsIncludeItem> include = options.getDetails().toList().isEmpty() ? null : options.getDetails().toList();
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().listBlobHierarchySegmentWithResponse(this.containerName, delimiter, options.getPrefix(), marker, options.getMaxResultsPerPage(), include, options.getStartFrom(), null, null, Context.NONE);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        BlobHierarchyListSegment segment = ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment();
        ArrayList value = new ArrayList();
        if (segment != null) {
            segment.getBlobItems().forEach(item -> value.add(BlobItemConstructorProxy.create(item)));
            segment.getBlobPrefixes().forEach(prefix -> value.add(new BlobItem().setName(ModelHelper.toBlobNameString(prefix.getName())).setIsPrefix(true)));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((ListBlobsHierarchySegmentResponse)response.getValue()).getNextMarker(), (Object)((ContainersListBlobHierarchySegmentHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BiFunction<String, Integer, PagedResponse> func = (marker, pageSize) -> {
            FindBlobsOptions finalOptions = pageSize != null ? new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.findBlobsByTagsHelper(finalOptions, (String)marker, timeout, context);
        };
        return new PagedIterable(pageSize -> (PagedResponse)func.apply((String)null, (Integer)pageSize), func);
    }

    private PagedResponse<TaggedBlobItem> findBlobsByTagsHelper(FindBlobsOptions options, String marker, Duration timeout, Context context) {
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().filterBlobsWithResponse(this.containerName, null, null, options.getQuery(), marker, options.getMaxResultsPerPage(), null, context);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        List value = ((FilterBlobSegment)response.getValue()).getBlobs().stream().map(ModelHelper::populateTaggedBlobItem).collect(Collectors.toList());
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FilterBlobSegment)response.getValue()).getNextMarker(), (Object)((ContainersFilterBlobsHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo(Duration timeout) {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(timeout, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getContainers().getAccountInfoWithResponse(this.containerName, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        ContainersGetAccountInfoHeaders hd = (ContainersGetAccountInfoHeaders)response.getDeserializedHeaders();
        return new SimpleResponse((Response)response, (Object)new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind()));
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, null, context);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateUserDelegationSas(userDelegationKey, accountName, stringToSignHandler, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.generateSas(blobServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.generateSas(blobServiceSasSignatureValues, null, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }
}

