/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.implementation.accesshelpers.BlobPropertiesConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobPropertiesInternalGetProperties;
import com.azure.storage.blob.implementation.models.BlobTag;
import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.storage.blob.implementation.models.BlobsCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlobsCreateSnapshotHeaders;
import com.azure.storage.blob.implementation.models.BlobsGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.BlobsGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.BlobsSetImmutabilityPolicyHeaders;
import com.azure.storage.blob.implementation.models.BlobsSetLegalHoldHeaders;
import com.azure.storage.blob.implementation.models.BlobsStartCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.InternalBlobLegalHoldResult;
import com.azure.storage.blob.implementation.util.BlobRequestConditionProperty;
import com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.azure.storage.blob.implementation.util.ByteBufferBackedOutputStreamUtil;
import com.azure.storage.blob.implementation.util.ChunkedDownloadUtils;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobBeginCopySourceRequestConditions;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadContentAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadContentResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobLegalHoldResult;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobQueryHeaders;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSeekableByteChannelReadResult;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ConsistentReadControl;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import com.azure.storage.blob.options.BlobCopyFromUrlOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobGetTagsOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobSeekableByteChannelReadOptions;
import com.azure.storage.blob.options.BlobSetAccessTierOptions;
import com.azure.storage.blob.options.BlobSetTagsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.StorageSeekableByteChannelBlobReadBehavior;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.FluxInputStream;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(BlobClientBase.class);
    private static final Set<OpenOption> DEFAULT_OPEN_OPTIONS_SET = Collections.unmodifiableSet(new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE)));
    final AzureBlobStorageImpl azureBlobStorage;
    private final String snapshot;
    private final String versionId;
    private final CpkInfo customerProvidedKey;
    final EncryptionScope encryptionScope;
    protected final String accountName;
    protected final String containerName;
    protected final String blobName;
    protected final BlobServiceVersion serviceVersion;
    private final BlobAsyncClientBase client;

    protected BlobClientBase(BlobAsyncClientBase client) {
        this(client, client.getHttpPipeline(), client.getAccountUrl(), client.getServiceVersion(), client.getAccountName(), client.getContainerName(), client.getBlobName(), client.getSnapshotId(), client.getCustomerProvidedKey(), new EncryptionScope().setEncryptionScope(client.getEncryptionScope()), client.getVersionId());
    }

    protected BlobClientBase(BlobAsyncClientBase client, HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        if (snapshot != null && versionId != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'snapshot' and 'versionId' cannot be used at the same time."));
        }
        this.client = client;
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.blobName = blobName;
        this.snapshot = snapshot;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.versionId = versionId;
        try {
            URI.create(this.getBlobUrl());
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)ex);
        }
    }

    public BlobClientBase getSnapshotClient(String snapshot) {
        return new BlobClientBase(this.client.getSnapshotClient(snapshot), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope, this.getVersionId());
    }

    public BlobClientBase getVersionClient(String versionId) {
        return new BlobClientBase(this.client.getVersionClient(versionId), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    public BlobClientBase getEncryptionScopeClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new BlobClientBase(this.client.getEncryptionScopeAsyncClient(encryptionScope), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.snapshot, this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    public BlobClientBase getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new BlobClientBase(this.client.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.snapshot, finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    public String getBlobUrl() {
        String blobUrl = this.azureBlobStorage.getUrl() + "/" + Utility.urlEncode((String)this.containerName) + "/" + Utility.urlEncode((String)this.blobName);
        if (this.isSnapshot()) {
            blobUrl = Utility.appendQueryParameter((String)blobUrl, (String)"snapshot", (String)this.getSnapshotId());
        }
        if (this.getVersionId() != null) {
            blobUrl = Utility.appendQueryParameter((String)blobUrl, (String)"versionid", (String)this.getVersionId());
        }
        return blobUrl;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public final String getContainerName() {
        return this.containerName;
    }

    public BlobContainerClient getContainerClient() {
        CustomerProvidedKey encryptionKey = this.customerProvidedKey == null ? null : new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
        return new BlobContainerClientBuilder().endpoint(this.getBlobUrl()).pipeline(this.getHttpPipeline()).serviceVersion(this.serviceVersion).customerProvidedKey(encryptionKey).encryptionScope(this.getEncryptionScope()).buildClient();
    }

    public final String getBlobName() {
        return this.blobName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public BlobInputStream openInputStream() {
        return this.openInputStream((BlobRange)null, null);
    }

    public BlobInputStream openInputStream(BlobRange range, BlobRequestConditions requestConditions) {
        return this.openInputStream(new BlobInputStreamOptions().setRange(range).setRequestConditions(requestConditions));
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options) {
        return this.openInputStream(options, null);
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options, Context context) {
        Context contextFinal = context == null ? Context.NONE : context;
        options = options == null ? new BlobInputStreamOptions() : options;
        ConsistentReadControl consistentReadControl = options.getConsistentReadControl() == null ? ConsistentReadControl.ETAG : options.getConsistentReadControl();
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        BlobRange range = options.getRange() == null ? new BlobRange(0L) : options.getRange();
        int chunkSize = options.getBlockSize() == null ? 0x400000 : options.getBlockSize();
        com.azure.storage.common.ParallelTransferOptions parallelTransferOptions = new com.azure.storage.common.ParallelTransferOptions().setBlockSizeLong(Long.valueOf(chunkSize));
        BiFunction<BlobRange, BlobRequestConditions, Mono<BlobDownloadAsyncResponse>> downloadFunc = (chunkRange, conditions) -> this.client.downloadStreamWithResponse((BlobRange)chunkRange, null, (BlobRequestConditions)((Object)conditions), false, contextFinal);
        return (BlobInputStream)((Object)ChunkedDownloadUtils.downloadFirstChunk(range, parallelTransferOptions, requestConditions, downloadFunc, true).flatMap(tuple3 -> {
            BlobDownloadAsyncResponse downloadResponse = (BlobDownloadAsyncResponse)tuple3.getT3();
            return FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)downloadResponse.getValue())).map(ByteBuffer::wrap).zipWith(Mono.just((Object)downloadResponse));
        }).flatMap(tuple2 -> {
            ByteBuffer initialBuffer = (ByteBuffer)tuple2.getT1();
            BlobDownloadAsyncResponse downloadResponse = (BlobDownloadAsyncResponse)tuple2.getT2();
            BlobProperties properties = (BlobProperties)ModelHelper.buildBlobPropertiesResponse(downloadResponse).getValue();
            String eTag = properties.getETag();
            String versionId = properties.getVersionId();
            BlobClientBase client = this;
            switch (consistentReadControl) {
                case NONE: {
                    break;
                }
                case ETAG: {
                    if (requestConditions.getIfMatch() != null) break;
                    requestConditions.setIfMatch(eTag);
                    break;
                }
                case VERSION_ID: {
                    if (versionId == null) {
                        return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new UnsupportedOperationException("Versioning is not supported on this account."));
                    }
                    if (this.getVersionId() != null) break;
                    client = this.getVersionClient(versionId);
                    break;
                }
                default: {
                    return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Concurrency control type not supported."));
                }
            }
            return Mono.just((Object)((Object)new BlobInputStream(client, range.getOffset(), range.getCount(), chunkSize, initialBuffer, requestConditions, properties, contextFinal)));
        }).block());
    }

    public BlobSeekableByteChannelReadResult openSeekableByteChannelRead(BlobSeekableByteChannelReadOptions options, Context context) {
        BlobProperties properties;
        context = context == null ? Context.NONE : context;
        options = options == null ? new BlobSeekableByteChannelReadOptions() : options;
        ConsistentReadControl consistentReadControl = options.getConsistentReadControl() == null ? ConsistentReadControl.ETAG : options.getConsistentReadControl();
        int chunkSize = options.getReadSizeInBytes() == null ? 0x400000 : options.getReadSizeInBytes();
        long initialPosition = options.getInitialPosition() == null ? 0L : options.getInitialPosition();
        ByteBuffer initialRange = ByteBuffer.allocate(chunkSize);
        try (ByteBufferBackedOutputStreamUtil dstStream = new ByteBufferBackedOutputStreamUtil(initialRange);){
            BlobDownloadResponse response = this.downloadStreamWithResponse(dstStream, new BlobRange(initialPosition, Long.valueOf(initialRange.remaining())), null, options.getRequestConditions(), false, null, context);
            properties = (BlobProperties)ModelHelper.buildBlobPropertiesResponse(response).getValue();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        initialRange.limit(initialRange.position());
        initialRange.rewind();
        BlobClientBase behaviorClient = this;
        BlobRequestConditions requestConditions = options.getRequestConditions();
        switch (consistentReadControl) {
            case NONE: {
                break;
            }
            case ETAG: {
                BlobRequestConditions blobRequestConditions = requestConditions = requestConditions != null ? requestConditions : new BlobRequestConditions();
                if (requestConditions.getIfMatch() != null) break;
                requestConditions.setIfMatch(properties.getETag());
                break;
            }
            case VERSION_ID: {
                if (properties.getVersionId() == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Version ID locking unsupported. Versioning is not supported on this account."));
                }
                if (this.getVersionId() != null) break;
                behaviorClient = this.getVersionClient(properties.getVersionId());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Concurrency control type " + (Object)((Object)consistentReadControl) + " not supported."));
            }
        }
        StorageSeekableByteChannelBlobReadBehavior behavior = new StorageSeekableByteChannelBlobReadBehavior(behaviorClient, initialRange, initialPosition, properties.getBlobSize(), requestConditions);
        StorageSeekableByteChannel channel = new StorageSeekableByteChannel(chunkSize, (StorageSeekableByteChannel.ReadBehavior)behavior, initialPosition);
        return new BlobSeekableByteChannelReadResult((SeekableByteChannel)channel, properties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        try {
            Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().getPropertiesNoCustomHeadersWithResponse(this.containerName, this.blobName, this.snapshot, this.versionId, null, null, null, null, null, null, null, null, this.customerProvidedKey, context);
            return new SimpleResponse((Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class), (Object)true);
        }
        catch (RuntimeException e) {
            if (e instanceof BlobStorageException) {
                HttpResponse response = ((BlobStorageException)((Object)e)).getResponse();
                if (BlobErrorCode.BLOB_USES_CUSTOMER_SPECIFIED_ENCRYPTION.equals((Object)((BlobStorageException)((Object)e)).getErrorCode())) {
                    return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)true);
                }
                if (((BlobStorageException)((Object)e)).getResponse().getStatusCode() == 404) {
                    return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
                }
                throw LOGGER.logExceptionAsError(e);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, pollInterval);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration pollInterval) {
        return this.beginCopy(new BlobBeginCopyOptions(sourceUrl).setMetadata(metadata).setTier(tier).setRehydratePriority(priority).setSourceRequestConditions(ModelHelper.populateBlobSourceRequestConditions(sourceModifiedRequestConditions)).setDestinationRequestConditions(destRequestConditions).setPollInterval(pollInterval));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(BlobBeginCopyOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        AtomicReference copyId = new AtomicReference();
        Duration interval = options.getPollInterval() != null ? options.getPollInterval() : Duration.ofSeconds(1L);
        BlobBeginCopySourceRequestConditions sourceModifiedConditions = options.getSourceRequestConditions() == null ? new BlobBeginCopySourceRequestConditions() : options.getSourceRequestConditions();
        BlobRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
        Function<PollingContext, PollResponse> syncActivationOperation = pollingContext -> {
            try {
                new URL(options.getSourceUrl());
            }
            catch (MalformedURLException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url.", ex));
            }
            ResponseBase<BlobsStartCopyFromURLHeaders, Void> response = this.azureBlobStorage.getBlobs().startCopyFromURLWithResponse(this.containerName, this.blobName, options.getSourceUrl(), null, options.getMetadata(), options.getTier(), options.getRehydratePriority(), sourceModifiedConditions.getIfModifiedSince(), sourceModifiedConditions.getIfUnmodifiedSince(), sourceModifiedConditions.getIfMatch(), sourceModifiedConditions.getIfNoneMatch(), sourceModifiedConditions.getTagsConditions(), destinationRequestConditions.getIfModifiedSince(), destinationRequestConditions.getIfUnmodifiedSince(), destinationRequestConditions.getIfMatch(), destinationRequestConditions.getIfNoneMatch(), destinationRequestConditions.getTagsConditions(), destinationRequestConditions.getLeaseId(), null, ModelHelper.tagsToString(options.getTags()), options.isSealDestination(), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), options.isLegalHold(), Context.NONE);
            BlobsStartCopyFromURLHeaders headers = (BlobsStartCopyFromURLHeaders)response.getDeserializedHeaders();
            copyId.set(headers.getXMsCopyId());
            return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)new BlobCopyInfo(options.getSourceUrl(), headers.getXMsCopyId(), headers.getXMsCopyStatus(), headers.getETag(), headers.getLastModified(), ModelHelper.getErrorCode(response.getHeaders()), headers.getXMsVersionId()));
        };
        Function<PollingContext, PollResponse> pollOperation = pollingContext -> this.onPoll((PollResponse<BlobCopyInfo>)pollingContext.getLatestResponse());
        BiFunction<PollingContext, PollResponse, BlobCopyInfo> cancelOperation = (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started."));
            }
            String copyIdentifier = ((BlobCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                LOGGER.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                this.abortCopyFromUrl(copyIdentifier);
                return (BlobCopyInfo)firstResponse.getValue();
            }
            return null;
        };
        Function<PollingContext, Void> fetchResultOperation = pollingContext -> null;
        return SyncPoller.createPoller((Duration)interval, syncActivationOperation, pollOperation, cancelOperation, fetchResultOperation);
    }

    private PollResponse<BlobCopyInfo> onPoll(PollResponse<BlobCopyInfo> pollResponse) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return pollResponse;
        }
        BlobCopyInfo lastInfo = (BlobCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            LOGGER.warning("BlobCopyInfo does not exist. Activation operation failed.");
            return new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null);
        }
        try {
            BlobProperties properties = this.getProperties();
            CopyStatusType status = properties.getCopyStatus();
            BlobCopyInfo result = new BlobCopyInfo(properties.getCopySource(), properties.getCopyId(), status, properties.getETag(), properties.getCopyCompletionTime(), properties.getCopyStatusDescription(), properties.getVersionId());
            LongRunningOperationStatus operationStatus = ModelHelper.mapStatusToLongRunningOperationStatus(status);
            return new PollResponse(operationStatus, (Object)result);
        }
        catch (Exception e) {
            return new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopyFromUrl(String copyId) {
        this.abortCopyFromUrlWithResponse(copyId, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyFromUrlWithResponse(String copyId, String leaseId, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().abortCopyFromURLNoCustomHeadersWithResponse(this.containerName, this.blobName, copyId, null, leaseId, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String copyFromUrl(String copySource) {
        return (String)this.copyFromUrlWithResponse(copySource, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration timeout, Context context) {
        return this.copyFromUrlWithResponse(new BlobCopyFromUrlOptions(copySource).setMetadata(metadata).setTier(tier).setSourceRequestConditions(sourceModifiedRequestConditions).setDestinationRequestConditions(destRequestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> copyFromUrlWithResponse(BlobCopyFromUrlOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        RequestConditions sourceModifiedRequestConditions = options.getSourceRequestConditions() == null ? new RequestConditions() : options.getSourceRequestConditions();
        BlobRequestConditions destRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
        try {
            new URL(options.getCopySource());
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'copySource' is not a valid url.", ex));
        }
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().copyFromURLWithResponse(this.containerName, this.blobName, options.getCopySource(), null, options.getMetadata(), options.getTier(), sourceModifiedRequestConditions.getIfModifiedSince(), sourceModifiedRequestConditions.getIfUnmodifiedSince(), sourceModifiedRequestConditions.getIfMatch(), sourceModifiedRequestConditions.getIfNoneMatch(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getTagsConditions(), destRequestConditions.getLeaseId(), null, null, ModelHelper.tagsToString(options.getTags()), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), options.hasLegalHold(), sourceAuth, options.getCopySourceTagsMode(), options.getSourceShareTokenIntent(), this.encryptionScope, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)((BlobsCopyFromURLHeaders)response.getDeserializedHeaders()).getXMsCopyId());
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void download(OutputStream stream) {
        this.downloadStream(stream);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadStream(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData downloadContent() {
        return (BinaryData)StorageImplUtils.blockWithOptionalTimeout(this.client.downloadContent(), null);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        return this.downloadStreamWithResponse(stream, range, options, requestConditions, getRangeContentMd5, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadStreamWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"stream", (Object)stream);
        Mono download = this.client.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)((Flux)response.getValue()), (OutputStream)stream).thenReturn((Object)new BlobDownloadResponse((BlobDownloadAsyncResponse)response)));
        return (BlobDownloadResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadContentResponse downloadContentWithResponse(DownloadRetryOptions options, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono download = this.client.downloadStreamWithResponse(null, options, requestConditions, false, context).flatMap(r -> BinaryData.fromFlux((Flux)((Flux)r.getValue())).map(data -> new BlobDownloadContentAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), (BinaryData)data, (BlobDownloadHeaders)r.getDeserializedHeaders()))).map(BlobDownloadContentResponse::new);
        return (BlobDownloadContentResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadContentResponse downloadContentWithResponse(DownloadRetryOptions options, BlobRequestConditions requestConditions, BlobRange range, boolean getRangeContentMd5, Duration timeout, Context context) {
        Mono download = this.client.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5, context).flatMap(r -> BinaryData.fromFlux((Flux)((Flux)r.getValue())).map(data -> new BlobDownloadContentAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), (BinaryData)data, (BlobDownloadHeaders)r.getDeserializedHeaders()))).map(BlobDownloadContentResponse::new);
        return (BlobDownloadContentResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return (BlobProperties)this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions(ModelHelper.populateAndApplyDefaults(parallelTransferOptions));
        return this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(downloadRetryOptions).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(BlobDownloadToFileOptions options, Duration timeout, Context context) {
        Mono<Response<BlobProperties>> download = this.client.downloadToFileWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(download, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().deleteNoCustomHeadersWithResponse(this.containerName, this.blobName, this.snapshot, this.versionId, null, finalRequestConditions.getLeaseId(), deleteBlobSnapshotOptions, finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        try {
            Response<Void> response = this.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, timeout, context);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)true);
        }
        catch (RuntimeException e) {
            if (e instanceof BlobStorageException && ((BlobStorageException)((Object)e)).getResponse().getStatusCode() == 404) {
                HttpResponse response = ((BlobStorageException)((Object)e)).getResponse();
                return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties getProperties() {
        return (BlobProperties)this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> getPropertiesWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().getPropertiesWithResponse(this.containerName, this.blobName, this.snapshot, this.versionId, null, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, this.customerProvidedKey, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)BlobPropertiesConstructorProxy.create(new BlobPropertiesInternalGetProperties((BlobsGetPropertiesHeaders)response.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setHttpHeaders(BlobHttpHeaders headers) {
        this.setHttpHeadersWithResponse(headers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().setHttpHeadersNoCustomHeadersWithResponse(this.containerName, this.blobName, null, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, headers, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().setMetadataNoCustomHeadersWithResponse(this.containerName, this.blobName, null, metadata, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, this.customerProvidedKey, this.encryptionScope, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, String> getTags() {
        return (Map)this.getTagsWithResponse(new BlobGetTagsOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, String>> getTagsWithResponse(BlobGetTagsOptions options, Duration timeout, Context context) {
        BlobGetTagsOptions finalTagOptions = options == null ? new BlobGetTagsOptions() : options;
        BlobRequestConditions requestConditions = finalTagOptions.getRequestConditions() == null ? new BlobRequestConditions() : finalTagOptions.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().getTagsWithResponse(this.containerName, this.blobName, null, null, this.snapshot, this.versionId, requestConditions.getTagsConditions(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (BlobTag tag : ((BlobTags)response.getValue()).getBlobTagSet()) {
            tags.put(tag.getKey(), tag.getValue());
        }
        return new SimpleResponse((Response)response, tags);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setTags(Map<String, String> tags) {
        this.setTagsWithResponse(new BlobSetTagsOptions(tags), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setTagsWithResponse(BlobSetTagsOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Context finalContext = context == null ? Context.NONE : context;
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        ArrayList<BlobTag> tagList = null;
        if (options.getTags() != null) {
            tagList = new ArrayList<BlobTag>();
            for (Map.Entry<String, String> entry : options.getTags().entrySet()) {
                tagList.add(new BlobTag().setKey(entry.getKey()).setValue(entry.getValue()));
            }
        }
        BlobTags t = new BlobTags().setBlobTagSet(tagList);
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().setTagsNoCustomHeadersWithResponse(this.containerName, this.blobName, null, this.versionId, null, null, null, requestConditions.getTagsConditions(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), t, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobClientBase createSnapshot() {
        return (BlobClientBase)this.createSnapshotWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobClientBase> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().createSnapshotWithResponse(this.containerName, this.blobName, null, metadata, finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), finalRequestConditions.getLeaseId(), null, this.customerProvidedKey, this.encryptionScope, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)this.getSnapshotClient(((BlobsCreateSnapshotHeaders)response.getDeserializedHeaders()).getXMsSnapshot()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessTier(AccessTier tier) {
        this.setAccessTierWithResponse(tier, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId, Duration timeout, Context context) {
        return this.setAccessTierWithResponse(new BlobSetAccessTierOptions(tier).setPriority(priority).setLeaseId(leaseId), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessTierWithResponse(BlobSetAccessTierOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().setTierNoCustomHeadersWithResponse(this.containerName, this.blobName, options.getTier(), this.snapshot, this.versionId, null, options.getPriority(), null, options.getLeaseId(), options.getTagsConditions(), finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void undelete() {
        this.undeleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> undeleteWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().undeleteNoCustomHeadersWithResponse(this.containerName, this.blobName, null, null, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo() {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().getAccountInfoWithResponse(this.containerName, this.blobName, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        BlobsGetAccountInfoHeaders hd = (BlobsGetAccountInfoHeaders)response.getDeserializedHeaders();
        return new SimpleResponse((Response)response, (Object)new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind()));
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, null, context);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getVersionId(), this.getEncryptionScope()).generateUserDelegationSas(userDelegationKey, accountName, stringToSignHandler, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.generateSas(blobServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.generateSas(blobServiceSasSignatureValues, null, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getVersionId(), this.getEncryptionScope()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream openQueryInputStream(String expression) {
        return (InputStream)this.openQueryInputStreamWithResponse(new BlobQueryOptions(expression)).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InputStream> openQueryInputStreamWithResponse(BlobQueryOptions queryOptions) {
        BlobQueryAsyncResponse response = (BlobQueryAsyncResponse)((Object)this.client.queryWithResponse(queryOptions).block());
        if (response == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Query response cannot be null"));
        }
        return new ResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new FluxInputStream((Flux)response.getValue()), (Object)((BlobQueryHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void query(OutputStream stream, String expression) {
        this.queryWithResponse(new BlobQueryOptions(expression, stream), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobQueryResponse queryWithResponse(BlobQueryOptions queryOptions, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)queryOptions);
        StorageImplUtils.assertNotNull((String)"outputStream", (Object)queryOptions.getOutputStream());
        Mono download = this.client.queryWithResponse(queryOptions, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)((Flux)response.getValue()), (OutputStream)queryOptions.getOutputStream()).thenReturn((Object)new BlobQueryResponse((BlobQueryAsyncResponse)((Object)response))));
        return (BlobQueryResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobImmutabilityPolicy setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        return (BlobImmutabilityPolicy)this.setImmutabilityPolicyWithResponse(immutabilityPolicy, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobImmutabilityPolicy> setImmutabilityPolicyWithResponse(BlobImmutabilityPolicy immutabilityPolicy, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobImmutabilityPolicy finalImmutabilityPolicy;
        Context finalContext = context == null ? Context.NONE : context;
        BlobImmutabilityPolicy blobImmutabilityPolicy = finalImmutabilityPolicy = immutabilityPolicy == null ? new BlobImmutabilityPolicy() : immutabilityPolicy;
        if (BlobImmutabilityPolicyMode.MUTABLE.equals((Object)finalImmutabilityPolicy.getPolicyMode())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("immutabilityPolicy.policyMode must be %s or %s", BlobImmutabilityPolicyMode.LOCKED.toString(), BlobImmutabilityPolicyMode.UNLOCKED.toString())));
        }
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        ModelHelper.validateConditionsNotPresent(finalRequestConditions, EnumSet.of(BlobRequestConditionProperty.LEASE_ID, BlobRequestConditionProperty.TAGS_CONDITIONS, BlobRequestConditionProperty.IF_MATCH, BlobRequestConditionProperty.IF_NONE_MATCH, BlobRequestConditionProperty.IF_MODIFIED_SINCE), "setImmutabilityPolicy(WithResponse)", "requestConditions");
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().setImmutabilityPolicyWithResponse(this.containerName, this.blobName, null, null, finalRequestConditions.getIfUnmodifiedSince(), finalImmutabilityPolicy.getExpiryTime(), finalImmutabilityPolicy.getPolicyMode(), this.snapshot, this.versionId, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        BlobsSetImmutabilityPolicyHeaders headers = (BlobsSetImmutabilityPolicyHeaders)response.getDeserializedHeaders();
        BlobImmutabilityPolicy responsePolicy = new BlobImmutabilityPolicy().setPolicyMode(headers.getXMsImmutabilityPolicyMode()).setExpiryTime(headers.getXMsImmutabilityPolicyUntilDate());
        return new SimpleResponse((Response)response, (Object)responsePolicy);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteImmutabilityPolicy() {
        this.deleteImmutabilityPolicyWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteImmutabilityPolicyWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getBlobs().deleteImmutabilityPolicyNoCustomHeadersWithResponse(this.containerName, this.blobName, null, null, this.snapshot, this.versionId, finalContext);
        return (Response)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobLegalHoldResult setLegalHold(boolean legalHold) {
        return (BlobLegalHoldResult)this.setLegalHoldWithResponse(legalHold, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobLegalHoldResult> setLegalHoldWithResponse(boolean legalHold, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getBlobs().setLegalHoldWithResponse(this.containerName, this.blobName, legalHold, null, null, this.snapshot, this.versionId, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.sendRequest(operation, (Duration)timeout, BlobStorageException.class);
        return new SimpleResponse((Response)response, (Object)new InternalBlobLegalHoldResult(((BlobsSetLegalHoldHeaders)response.getDeserializedHeaders()).isXMsLegalHold()));
    }
}

