/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlockLookupList
implements XmlSerializable<BlockLookupList> {
    private List<String> committed = new ArrayList<String>();
    private List<String> uncommitted = new ArrayList<String>();
    private List<String> latest = new ArrayList<String>();

    public List<String> getCommitted() {
        return this.committed;
    }

    public BlockLookupList setCommitted(List<String> committed) {
        this.committed = committed;
        return this;
    }

    public List<String> getUncommitted() {
        return this.uncommitted;
    }

    public BlockLookupList setUncommitted(List<String> uncommitted) {
        this.uncommitted = uncommitted;
        return this;
    }

    public List<String> getLatest() {
        return this.latest;
    }

    public BlockLookupList setLatest(List<String> latest) {
        this.latest = latest;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlockList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.committed != null) {
            for (String element : this.committed) {
                xmlWriter.writeStringElement("Committed", element);
            }
        }
        if (this.uncommitted != null) {
            for (String element : this.uncommitted) {
                xmlWriter.writeStringElement("Uncommitted", element);
            }
        }
        if (this.latest != null) {
            for (String element : this.latest) {
                xmlWriter.writeStringElement("Latest", element);
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static BlockLookupList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlockLookupList.fromXml(xmlReader, null);
    }

    public static BlockLookupList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlockList" : rootElementName;
        return (BlockLookupList)xmlReader.readObject(finalRootElementName, reader -> {
            BlockLookupList deserializedBlockLookupList = new BlockLookupList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Committed".equals(elementName.getLocalPart())) {
                    deserializedBlockLookupList.committed.add(reader.getStringElement());
                    continue;
                }
                if ("Uncommitted".equals(elementName.getLocalPart())) {
                    deserializedBlockLookupList.uncommitted.add(reader.getStringElement());
                    continue;
                }
                if ("Latest".equals(elementName.getLocalPart())) {
                    deserializedBlockLookupList.latest.add(reader.getStringElement());
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlockLookupList;
        });
    }
}

