/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.models.BlobAnalyticsLogging;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobMetrics;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.StaticWebsite;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobServiceProperties
implements XmlSerializable<BlobServiceProperties> {
    private BlobAnalyticsLogging logging;
    private BlobMetrics hourMetrics;
    private BlobMetrics minuteMetrics;
    private List<BlobCorsRule> cors;
    private String defaultServiceVersion;
    private BlobRetentionPolicy deleteRetentionPolicy;
    private StaticWebsite staticWebsite;

    public BlobAnalyticsLogging getLogging() {
        return this.logging;
    }

    public BlobServiceProperties setLogging(BlobAnalyticsLogging logging) {
        this.logging = logging;
        return this;
    }

    public BlobMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    public BlobServiceProperties setHourMetrics(BlobMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public BlobMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public BlobServiceProperties setMinuteMetrics(BlobMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<BlobCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<BlobCorsRule>();
        }
        return this.cors;
    }

    public BlobServiceProperties setCors(List<BlobCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    public String getDefaultServiceVersion() {
        return this.defaultServiceVersion;
    }

    public BlobServiceProperties setDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
        return this;
    }

    public BlobRetentionPolicy getDeleteRetentionPolicy() {
        return this.deleteRetentionPolicy;
    }

    public BlobServiceProperties setDeleteRetentionPolicy(BlobRetentionPolicy deleteRetentionPolicy) {
        this.deleteRetentionPolicy = deleteRetentionPolicy;
        return this;
    }

    public StaticWebsite getStaticWebsite() {
        return this.staticWebsite;
    }

    public BlobServiceProperties setStaticWebsite(StaticWebsite staticWebsite) {
        this.staticWebsite = staticWebsite;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.logging, "Logging");
        xmlWriter.writeXml((XmlSerializable)this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml((XmlSerializable)this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (BlobCorsRule element : this.cors) {
                xmlWriter.writeXml((XmlSerializable)element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement("DefaultServiceVersion", this.defaultServiceVersion);
        xmlWriter.writeXml((XmlSerializable)this.deleteRetentionPolicy, "DeleteRetentionPolicy");
        xmlWriter.writeXml((XmlSerializable)this.staticWebsite, "StaticWebsite");
        return xmlWriter.writeEndElement();
    }

    public static BlobServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobServiceProperties.fromXml(xmlReader, null);
    }

    public static BlobServiceProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        return (BlobServiceProperties)xmlReader.readObject(finalRootElementName, reader -> {
            BlobServiceProperties deserializedBlobServiceProperties = new BlobServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Logging".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.logging = BlobAnalyticsLogging.fromXml(reader, "Logging");
                    continue;
                }
                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.hourMetrics = BlobMetrics.fromXml(reader, "HourMetrics");
                    continue;
                }
                if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.minuteMetrics = BlobMetrics.fromXml(reader, "MinuteMetrics");
                    continue;
                }
                if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedBlobServiceProperties.cors == null) {
                                deserializedBlobServiceProperties.cors = new ArrayList<BlobCorsRule>();
                            }
                            deserializedBlobServiceProperties.cors.add(BlobCorsRule.fromXml(reader, "CorsRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("DefaultServiceVersion".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.defaultServiceVersion = reader.getStringElement();
                    continue;
                }
                if ("DeleteRetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.deleteRetentionPolicy = BlobRetentionPolicy.fromXml(reader, "DeleteRetentionPolicy");
                    continue;
                }
                if ("StaticWebsite".equals(elementName.getLocalPart())) {
                    deserializedBlobServiceProperties.staticWebsite = StaticWebsite.fromXml(reader, "StaticWebsite");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobServiceProperties;
        });
    }
}

