/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BlobsDownloadHeaders {
    private Boolean xMsIsCurrentVersion;
    private LeaseStatusType xMsLeaseStatus;
    private Long xMsTagCount;
    private String contentRange;
    private LeaseStateType xMsLeaseState;
    private Boolean xMsBlobSealed;
    private DateTimeRfc1123 lastModified;
    private String xMsVersionId;
    private String xMsEncryptionKeySha256;
    private String xMsStructuredBody;
    private BlobType xMsBlobType;
    private String xMsImmutabilityPolicyMode;
    private Long xMsStructuredContentLength;
    private String contentEncoding;
    private String xMsCopyStatusDescription;
    private DateTimeRfc1123 xMsCreationTime;
    private LeaseDurationType xMsLeaseDuration;
    private Long contentLength;
    private String xMsRequestId;
    private String contentType;
    private DateTimeRfc1123 xMsLastAccessTime;
    private String xMsVersion;
    private String xMsCopyId;
    private String xMsCopySource;
    private DateTimeRfc1123 xMsImmutabilityPolicyUntilDate;
    private byte[] xMsContentCrc64;
    private Long xMsBlobSequenceNumber;
    private String xMsCopyProgress;
    private Integer xMsBlobCommittedBlockCount;
    private byte[] xMsBlobContentMd5;
    private Map<String, String> xMsMeta;
    private Boolean xMsLegalHold;
    private DateTimeRfc1123 date;
    private byte[] contentMD5;
    private DateTimeRfc1123 xMsCopyCompletionTime;
    private String acceptRanges;
    private Boolean xMsServerEncrypted;
    private String xMsOrPolicyId;
    private String cacheControl;
    private String eTag;
    private String contentDisposition;
    private CopyStatusType xMsCopyStatus;
    private String contentLanguage;
    private String xMsClientRequestId;
    private Map<String, String> xMsOr;
    private String xMsEncryptionScope;
    private static final HttpHeaderName X_MS_IS_CURRENT_VERSION = HttpHeaderName.fromString((String)"x-ms-is-current-version");
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString((String)"x-ms-lease-status");
    private static final HttpHeaderName X_MS_TAG_COUNT = HttpHeaderName.fromString((String)"x-ms-tag-count");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString((String)"x-ms-lease-state");
    private static final HttpHeaderName X_MS_BLOB_SEALED = HttpHeaderName.fromString((String)"x-ms-blob-sealed");
    private static final HttpHeaderName X_MS_VERSION_ID = HttpHeaderName.fromString((String)"x-ms-version-id");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString((String)"x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_STRUCTURED_BODY = HttpHeaderName.fromString((String)"x-ms-structured-body");
    private static final HttpHeaderName X_MS_BLOB_TYPE = HttpHeaderName.fromString((String)"x-ms-blob-type");
    private static final HttpHeaderName X_MS_IMMUTABILITY_POLICY_MODE = HttpHeaderName.fromString((String)"x-ms-immutability-policy-mode");
    private static final HttpHeaderName X_MS_STRUCTURED_CONTENT_LENGTH = HttpHeaderName.fromString((String)"x-ms-structured-content-length");
    private static final HttpHeaderName X_MS_COPY_STATUS_DESCRIPTION = HttpHeaderName.fromString((String)"x-ms-copy-status-description");
    private static final HttpHeaderName X_MS_CREATION_TIME = HttpHeaderName.fromString((String)"x-ms-creation-time");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString((String)"x-ms-lease-duration");
    private static final HttpHeaderName X_MS_LAST_ACCESS_TIME = HttpHeaderName.fromString((String)"x-ms-last-access-time");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_COPY_ID = HttpHeaderName.fromString((String)"x-ms-copy-id");
    private static final HttpHeaderName X_MS_COPY_SOURCE = HttpHeaderName.fromString((String)"x-ms-copy-source");
    private static final HttpHeaderName X_MS_IMMUTABILITY_POLICY_UNTIL_DATE = HttpHeaderName.fromString((String)"x-ms-immutability-policy-until-date");
    private static final HttpHeaderName X_MS_CONTENT_CRC64 = HttpHeaderName.fromString((String)"x-ms-content-crc64");
    private static final HttpHeaderName X_MS_BLOB_SEQUENCE_NUMBER = HttpHeaderName.fromString((String)"x-ms-blob-sequence-number");
    private static final HttpHeaderName X_MS_COPY_PROGRESS = HttpHeaderName.fromString((String)"x-ms-copy-progress");
    private static final HttpHeaderName X_MS_BLOB_COMMITTED_BLOCK_COUNT = HttpHeaderName.fromString((String)"x-ms-blob-committed-block-count");
    private static final HttpHeaderName X_MS_BLOB_CONTENT_MD5 = HttpHeaderName.fromString((String)"x-ms-blob-content-md5");
    private static final HttpHeaderName X_MS_LEGAL_HOLD = HttpHeaderName.fromString((String)"x-ms-legal-hold");
    private static final HttpHeaderName X_MS_COPY_COMPLETION_TIME = HttpHeaderName.fromString((String)"x-ms-copy-completion-time");
    private static final HttpHeaderName X_MS_SERVER_ENCRYPTED = HttpHeaderName.fromString((String)"x-ms-server-encrypted");
    private static final HttpHeaderName X_MS_OR_POLICY_ID = HttpHeaderName.fromString((String)"x-ms-or-policy-id");
    private static final HttpHeaderName X_MS_COPY_STATUS = HttpHeaderName.fromString((String)"x-ms-copy-status");
    private static final HttpHeaderName X_MS_ENCRYPTION_SCOPE = HttpHeaderName.fromString((String)"x-ms-encryption-scope");

    public BlobsDownloadHeaders(HttpHeaders rawHeaders) {
        String xMsIsCurrentVersion = rawHeaders.getValue(X_MS_IS_CURRENT_VERSION);
        this.xMsIsCurrentVersion = xMsIsCurrentVersion != null ? Boolean.valueOf(Boolean.parseBoolean(xMsIsCurrentVersion)) : null;
        String xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        this.xMsLeaseStatus = xMsLeaseStatus != null ? LeaseStatusType.fromString(xMsLeaseStatus) : null;
        String xMsTagCount = rawHeaders.getValue(X_MS_TAG_COUNT);
        this.xMsTagCount = xMsTagCount != null ? Long.valueOf(Long.parseLong(xMsTagCount)) : null;
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        String xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        this.xMsLeaseState = xMsLeaseState != null ? LeaseStateType.fromString(xMsLeaseState) : null;
        String xMsBlobSealed = rawHeaders.getValue(X_MS_BLOB_SEALED);
        this.xMsBlobSealed = xMsBlobSealed != null ? Boolean.valueOf(Boolean.parseBoolean(xMsBlobSealed)) : null;
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        this.xMsVersionId = rawHeaders.getValue(X_MS_VERSION_ID);
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        this.xMsStructuredBody = rawHeaders.getValue(X_MS_STRUCTURED_BODY);
        String xMsBlobType = rawHeaders.getValue(X_MS_BLOB_TYPE);
        this.xMsBlobType = xMsBlobType != null ? BlobType.fromString(xMsBlobType) : null;
        this.xMsImmutabilityPolicyMode = rawHeaders.getValue(X_MS_IMMUTABILITY_POLICY_MODE);
        String xMsStructuredContentLength = rawHeaders.getValue(X_MS_STRUCTURED_CONTENT_LENGTH);
        this.xMsStructuredContentLength = xMsStructuredContentLength != null ? Long.valueOf(Long.parseLong(xMsStructuredContentLength)) : null;
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        this.xMsCopyStatusDescription = rawHeaders.getValue(X_MS_COPY_STATUS_DESCRIPTION);
        String xMsCreationTime = rawHeaders.getValue(X_MS_CREATION_TIME);
        this.xMsCreationTime = xMsCreationTime != null ? new DateTimeRfc1123(xMsCreationTime) : null;
        String xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        this.xMsLeaseDuration = xMsLeaseDuration != null ? LeaseDurationType.fromString(xMsLeaseDuration) : null;
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        this.contentLength = contentLength != null ? Long.valueOf(Long.parseLong(contentLength)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        String xMsLastAccessTime = rawHeaders.getValue(X_MS_LAST_ACCESS_TIME);
        this.xMsLastAccessTime = xMsLastAccessTime != null ? new DateTimeRfc1123(xMsLastAccessTime) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsCopyId = rawHeaders.getValue(X_MS_COPY_ID);
        this.xMsCopySource = rawHeaders.getValue(X_MS_COPY_SOURCE);
        String xMsImmutabilityPolicyUntilDate = rawHeaders.getValue(X_MS_IMMUTABILITY_POLICY_UNTIL_DATE);
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate != null ? new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate) : null;
        String xMsContentCrc64 = rawHeaders.getValue(X_MS_CONTENT_CRC64);
        this.xMsContentCrc64 = (byte[])(xMsContentCrc64 != null ? Base64.getDecoder().decode(xMsContentCrc64) : null);
        String xMsBlobSequenceNumber = rawHeaders.getValue(X_MS_BLOB_SEQUENCE_NUMBER);
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber != null ? Long.valueOf(Long.parseLong(xMsBlobSequenceNumber)) : null;
        this.xMsCopyProgress = rawHeaders.getValue(X_MS_COPY_PROGRESS);
        String xMsBlobCommittedBlockCount = rawHeaders.getValue(X_MS_BLOB_COMMITTED_BLOCK_COUNT);
        this.xMsBlobCommittedBlockCount = xMsBlobCommittedBlockCount != null ? Integer.valueOf(Integer.parseInt(xMsBlobCommittedBlockCount)) : null;
        String xMsBlobContentMd5 = rawHeaders.getValue(X_MS_BLOB_CONTENT_MD5);
        this.xMsBlobContentMd5 = (byte[])(xMsBlobContentMd5 != null ? Base64.getDecoder().decode(xMsBlobContentMd5) : null);
        String xMsLegalHold = rawHeaders.getValue(X_MS_LEGAL_HOLD);
        this.xMsLegalHold = xMsLegalHold != null ? Boolean.valueOf(Boolean.parseBoolean(xMsLegalHold)) : null;
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        String contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5);
        this.contentMD5 = (byte[])(contentMD5 != null ? Base64.getDecoder().decode(contentMD5) : null);
        String xMsCopyCompletionTime = rawHeaders.getValue(X_MS_COPY_COMPLETION_TIME);
        this.xMsCopyCompletionTime = xMsCopyCompletionTime != null ? new DateTimeRfc1123(xMsCopyCompletionTime) : null;
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        String xMsServerEncrypted = rawHeaders.getValue(X_MS_SERVER_ENCRYPTED);
        this.xMsServerEncrypted = xMsServerEncrypted != null ? Boolean.valueOf(Boolean.parseBoolean(xMsServerEncrypted)) : null;
        this.xMsOrPolicyId = rawHeaders.getValue(X_MS_OR_POLICY_ID);
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        String xMsCopyStatus = rawHeaders.getValue(X_MS_COPY_STATUS);
        this.xMsCopyStatus = xMsCopyStatus != null ? CopyStatusType.fromString(xMsCopyStatus) : null;
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        this.xMsEncryptionScope = rawHeaders.getValue(X_MS_ENCRYPTION_SCOPE);
        LinkedHashMap<String, String> xMsMetaHeaderCollection = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> xMsOrHeaderCollection = new LinkedHashMap<String, String>();
        rawHeaders.stream().forEach(header -> {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
                return;
            }
            if (headerName.startsWith("x-ms-or-")) {
                xMsOrHeaderCollection.put(headerName.substring(8), header.getValue());
            }
        });
        this.xMsMeta = xMsMetaHeaderCollection;
        this.xMsOr = xMsOrHeaderCollection;
    }

    public Boolean isXMsIsCurrentVersion() {
        return this.xMsIsCurrentVersion;
    }

    public BlobsDownloadHeaders setXMsIsCurrentVersion(Boolean xMsIsCurrentVersion) {
        this.xMsIsCurrentVersion = xMsIsCurrentVersion;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public BlobsDownloadHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public Long getXMsTagCount() {
        return this.xMsTagCount;
    }

    public BlobsDownloadHeaders setXMsTagCount(Long xMsTagCount) {
        this.xMsTagCount = xMsTagCount;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public BlobsDownloadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public BlobsDownloadHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public Boolean isXMsBlobSealed() {
        return this.xMsBlobSealed;
    }

    public BlobsDownloadHeaders setXMsBlobSealed(Boolean xMsBlobSealed) {
        this.xMsBlobSealed = xMsBlobSealed;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobsDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsVersionId() {
        return this.xMsVersionId;
    }

    public BlobsDownloadHeaders setXMsVersionId(String xMsVersionId) {
        this.xMsVersionId = xMsVersionId;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public BlobsDownloadHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public String getXMsStructuredBody() {
        return this.xMsStructuredBody;
    }

    public BlobsDownloadHeaders setXMsStructuredBody(String xMsStructuredBody) {
        this.xMsStructuredBody = xMsStructuredBody;
        return this;
    }

    public BlobType getXMsBlobType() {
        return this.xMsBlobType;
    }

    public BlobsDownloadHeaders setXMsBlobType(BlobType xMsBlobType) {
        this.xMsBlobType = xMsBlobType;
        return this;
    }

    public String getXMsImmutabilityPolicyMode() {
        return this.xMsImmutabilityPolicyMode;
    }

    public BlobsDownloadHeaders setXMsImmutabilityPolicyMode(String xMsImmutabilityPolicyMode) {
        this.xMsImmutabilityPolicyMode = xMsImmutabilityPolicyMode;
        return this;
    }

    public Long getXMsStructuredContentLength() {
        return this.xMsStructuredContentLength;
    }

    public BlobsDownloadHeaders setXMsStructuredContentLength(Long xMsStructuredContentLength) {
        this.xMsStructuredContentLength = xMsStructuredContentLength;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobsDownloadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public BlobsDownloadHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public OffsetDateTime getXMsCreationTime() {
        if (this.xMsCreationTime == null) {
            return null;
        }
        return this.xMsCreationTime.getDateTime();
    }

    public BlobsDownloadHeaders setXMsCreationTime(OffsetDateTime xMsCreationTime) {
        this.xMsCreationTime = xMsCreationTime == null ? null : new DateTimeRfc1123(xMsCreationTime);
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public BlobsDownloadHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobsDownloadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsDownloadHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobsDownloadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public OffsetDateTime getXMsLastAccessTime() {
        if (this.xMsLastAccessTime == null) {
            return null;
        }
        return this.xMsLastAccessTime.getDateTime();
    }

    public BlobsDownloadHeaders setXMsLastAccessTime(OffsetDateTime xMsLastAccessTime) {
        this.xMsLastAccessTime = xMsLastAccessTime == null ? null : new DateTimeRfc1123(xMsLastAccessTime);
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsDownloadHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public BlobsDownloadHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public BlobsDownloadHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public OffsetDateTime getXMsImmutabilityPolicyUntilDate() {
        if (this.xMsImmutabilityPolicyUntilDate == null) {
            return null;
        }
        return this.xMsImmutabilityPolicyUntilDate.getDateTime();
    }

    public BlobsDownloadHeaders setXMsImmutabilityPolicyUntilDate(OffsetDateTime xMsImmutabilityPolicyUntilDate) {
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate == null ? null : new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate);
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public BlobsDownloadHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public Long getXMsBlobSequenceNumber() {
        return this.xMsBlobSequenceNumber;
    }

    public BlobsDownloadHeaders setXMsBlobSequenceNumber(Long xMsBlobSequenceNumber) {
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public BlobsDownloadHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Integer getXMsBlobCommittedBlockCount() {
        return this.xMsBlobCommittedBlockCount;
    }

    public BlobsDownloadHeaders setXMsBlobCommittedBlockCount(Integer xMsBlobCommittedBlockCount) {
        this.xMsBlobCommittedBlockCount = xMsBlobCommittedBlockCount;
        return this;
    }

    public byte[] getXMsBlobContentMd5() {
        return CoreUtils.clone((byte[])this.xMsBlobContentMd5);
    }

    public BlobsDownloadHeaders setXMsBlobContentMd5(byte[] xMsBlobContentMd5) {
        this.xMsBlobContentMd5 = CoreUtils.clone((byte[])xMsBlobContentMd5);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public BlobsDownloadHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public Boolean isXMsLegalHold() {
        return this.xMsLegalHold;
    }

    public BlobsDownloadHeaders setXMsLegalHold(Boolean xMsLegalHold) {
        this.xMsLegalHold = xMsLegalHold;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public BlobsDownloadHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlobsDownloadHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public BlobsDownloadHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobsDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public BlobsDownloadHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getXMsOrPolicyId() {
        return this.xMsOrPolicyId;
    }

    public BlobsDownloadHeaders setXMsOrPolicyId(String xMsOrPolicyId) {
        this.xMsOrPolicyId = xMsOrPolicyId;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobsDownloadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobsDownloadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobsDownloadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public BlobsDownloadHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobsDownloadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsDownloadHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public Map<String, String> getXMsOr() {
        return this.xMsOr;
    }

    public BlobsDownloadHeaders setXMsOr(Map<String, String> xMsOr) {
        this.xMsOr = xMsOr;
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public BlobsDownloadHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

