// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * signed identifier.
 */
@Fluent
public final class BlobSignedIdentifier implements XmlSerializable<BlobSignedIdentifier> {
    /*
     * a unique id
     */
    @Generated
    private String id;

    /*
     * An Access policy
     */
    @Generated
    private BlobAccessPolicy accessPolicy;

    /**
     * Creates an instance of BlobSignedIdentifier class.
     */
    @Generated
    public BlobSignedIdentifier() {
    }

    /**
     * Get the id property: a unique id.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: a unique id.
     * 
     * @param id the id value to set.
     * @return the BlobSignedIdentifier object itself.
     */
    @Generated
    public BlobSignedIdentifier setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the accessPolicy property: An Access policy.
     * 
     * @return the accessPolicy value.
     */
    @Generated
    public BlobAccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    /**
     * Set the accessPolicy property: An Access policy.
     * 
     * @param accessPolicy the accessPolicy value to set.
     * @return the BlobSignedIdentifier object itself.
     */
    @Generated
    public BlobSignedIdentifier setAccessPolicy(BlobAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifier" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Id", this.id);
        xmlWriter.writeXml(this.accessPolicy, "AccessPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobSignedIdentifier from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobSignedIdentifier.
     */
    @Generated
    public static BlobSignedIdentifier fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobSignedIdentifier from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobSignedIdentifier if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobSignedIdentifier.
     */
    @Generated
    public static BlobSignedIdentifier fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifier" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobSignedIdentifier deserializedBlobSignedIdentifier = new BlobSignedIdentifier();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Id".equals(elementName.getLocalPart())) {
                    deserializedBlobSignedIdentifier.id = reader.getStringElement();
                } else if ("AccessPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobSignedIdentifier.accessPolicy = BlobAccessPolicy.fromXml(reader, "AccessPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobSignedIdentifier;
        });
    }
}
