// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An Access policy.
 */
@Fluent
public final class BlobAccessPolicy implements XmlSerializable<BlobAccessPolicy> {
    /*
     * the date-time the policy is active
     */
    @Generated
    private OffsetDateTime startsOn;

    /*
     * the date-time the policy expires
     */
    @Generated
    private OffsetDateTime expiresOn;

    /*
     * the permissions for the acl policy
     */
    @Generated
    private String permissions;

    /**
     * Creates an instance of BlobAccessPolicy class.
     */
    @Generated
    public BlobAccessPolicy() {
    }

    /**
     * Get the startsOn property: the date-time the policy is active.
     * 
     * @return the startsOn value.
     */
    @Generated
    public OffsetDateTime getStartsOn() {
        return this.startsOn;
    }

    /**
     * Set the startsOn property: the date-time the policy is active.
     * 
     * @param startsOn the startsOn value to set.
     * @return the BlobAccessPolicy object itself.
     */
    @Generated
    public BlobAccessPolicy setStartsOn(OffsetDateTime startsOn) {
        this.startsOn = startsOn;
        return this;
    }

    /**
     * Get the expiresOn property: the date-time the policy expires.
     * 
     * @return the expiresOn value.
     */
    @Generated
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * Set the expiresOn property: the date-time the policy expires.
     * 
     * @param expiresOn the expiresOn value to set.
     * @return the BlobAccessPolicy object itself.
     */
    @Generated
    public BlobAccessPolicy setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * Get the permissions property: the permissions for the acl policy.
     * 
     * @return the permissions value.
     */
    @Generated
    public String getPermissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: the permissions for the acl policy.
     * 
     * @param permissions the permissions value to set.
     * @return the BlobAccessPolicy object itself.
     */
    @Generated
    public BlobAccessPolicy setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlobAccessPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Start",
            this.startsOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startsOn));
        xmlWriter.writeStringElement("Expiry",
            this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        xmlWriter.writeStringElement("Permission", this.permissions);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobAccessPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobAccessPolicy if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobAccessPolicy.
     */
    @Generated
    public static BlobAccessPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobAccessPolicy from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobAccessPolicy if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobAccessPolicy.
     */
    @Generated
    public static BlobAccessPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "BlobAccessPolicy" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobAccessPolicy deserializedBlobAccessPolicy = new BlobAccessPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.startsOn
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("Expiry".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.expiresOn
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("Permission".equals(elementName.getLocalPart())) {
                    deserializedBlobAccessPolicy.permissions = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobAccessPolicy;
        });
    }
}
