// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;BlobSignedIdentifier&gt; which provides top-level metadata for serialization.
 */
public final class BlobSignedIdentifierWrapper implements XmlSerializable<BlobSignedIdentifierWrapper> {

    private final List<BlobSignedIdentifier> signedIdentifiers;

    /**
     * Creates an instance of BlobSignedIdentifierWrapper.
     *
     * @param signedIdentifiers the list.
     */
    public BlobSignedIdentifierWrapper(List<BlobSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    /**
     * Get the List&lt;BlobSignedIdentifier&gt; contained in this wrapper.
     *
     * @return the List&lt;BlobSignedIdentifier&gt;.
     */
    public List<BlobSignedIdentifier> items() {
        return signedIdentifiers;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (signedIdentifiers != null) {
            for (BlobSignedIdentifier element : signedIdentifiers) {
                xmlWriter.writeXml(element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobSignedIdentifierWrapper from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobSignedIdentifierWrapper if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobSignedIdentifierWrapper.
     */
    @Generated
    public static BlobSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobSignedIdentifierWrapper from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobSignedIdentifierWrapper if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobSignedIdentifierWrapper.
     */
    @Generated
    public static BlobSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "SignedIdentifiers" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<BlobSignedIdentifier> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }
                    items.add(BlobSignedIdentifier.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new BlobSignedIdentifierWrapper(items);
        });
    }
}
