// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The BlobFlatListSegment model.
 */
@Fluent
public final class BlobFlatListSegment implements XmlSerializable<BlobFlatListSegment> {
    /*
     * The BlobItems property.
     */
    @Generated
    private List<BlobItemInternal> blobItems = new ArrayList<>();

    /**
     * Creates an instance of BlobFlatListSegment class.
     */
    @Generated
    public BlobFlatListSegment() {
    }

    /**
     * Get the blobItems property: The BlobItems property.
     * 
     * @return the blobItems value.
     */
    @Generated
    public List<BlobItemInternal> getBlobItems() {
        return this.blobItems;
    }

    /**
     * Set the blobItems property: The BlobItems property.
     * 
     * @param blobItems the blobItems value to set.
     * @return the BlobFlatListSegment object itself.
     */
    @Generated
    public BlobFlatListSegment setBlobItems(List<BlobItemInternal> blobItems) {
        this.blobItems = blobItems;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blobs" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.blobItems != null) {
            for (BlobItemInternal element : this.blobItems) {
                xmlWriter.writeXml(element, "Blob");
            }
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobFlatListSegment from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobFlatListSegment if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobFlatListSegment.
     */
    @Generated
    public static BlobFlatListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobFlatListSegment from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobFlatListSegment if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobFlatListSegment.
     */
    @Generated
    public static BlobFlatListSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blobs" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobFlatListSegment deserializedBlobFlatListSegment = new BlobFlatListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Blob".equals(elementName.getLocalPart())) {
                    deserializedBlobFlatListSegment.blobItems.add(BlobItemInternal.fromXml(reader, "Blob"));
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobFlatListSegment;
        });
    }
}
