// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesDiffHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsResizeHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesFromURLHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesHeaders;
import com.azure.storage.blob.implementation.models.PremiumPageBlobAccessTier;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.FileShareTokenIntent;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.SequenceNumberActionType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PageBlobs.
 */
public final class PageBlobsImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final PageBlobsService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureBlobStorageImpl client;

    /**
     * Initializes an instance of PageBlobsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PageBlobsImpl(AzureBlobStorageImpl client) {
        this.service
            = RestProxy.create(PageBlobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureBlobStoragePageBlobs to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureBlobStoragePageBlobs")
    public interface PageBlobsService {

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsCreateHeaders, Void>> create(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-access-tier") PremiumPageBlobAccessTier tier,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> createNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-access-tier") PremiumPageBlobAccessTier tier,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsCreateHeaders, Void> createSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-access-tier") PremiumPageBlobAccessTier tier,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> createNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-access-tier") PremiumPageBlobAccessTier tier,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPages(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> uploadPagesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPages(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> uploadPagesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsUploadPagesHeaders, Void> uploadPagesSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> uploadPagesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsClearPagesHeaders, Void>> clearPages(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> clearPagesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsClearPagesHeaders, Void> clearPagesSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> clearPagesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsUploadPagesFromURLHeaders, Void>> uploadPagesFromURL(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("x-ms-copy-source") String sourceUrl, @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-file-request-intent") FileShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> uploadPagesFromURLNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("x-ms-copy-source") String sourceUrl, @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-file-request-intent") FileShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsUploadPagesFromURLHeaders, Void> uploadPagesFromURLSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("x-ms-copy-source") String sourceUrl, @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-file-request-intent") FileShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> uploadPagesFromURLNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @HeaderParam("x-ms-page-write") String pageWrite,
            @HeaderParam("x-ms-copy-source") String sourceUrl, @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64,
            @HeaderParam("Content-Length") long contentLength, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-range") String range, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-if-sequence-number-le") Long ifSequenceNumberLessThanOrEqualTo,
            @HeaderParam("x-ms-if-sequence-number-lt") Long ifSequenceNumberLessThan,
            @HeaderParam("x-ms-if-sequence-number-eq") Long ifSequenceNumberEqualTo,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-file-request-intent") FileShareTokenIntent fileRequestIntent,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsGetPageRangesHeaders, PageList>> getPageRanges(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<PageList>> getPageRangesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsGetPageRangesHeaders, PageList> getPageRangesSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<PageList> getPageRangesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList>> getPageRangesDiff(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @QueryParam("prevsnapshot") String prevsnapshot,
            @HeaderParam("x-ms-previous-snapshot-url") String prevSnapshotUrl, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<PageList>> getPageRangesDiffNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @QueryParam("prevsnapshot") String prevsnapshot,
            @HeaderParam("x-ms-previous-snapshot-url") String prevSnapshotUrl, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList> getPageRangesDiffSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @QueryParam("prevsnapshot") String prevsnapshot,
            @HeaderParam("x-ms-previous-snapshot-url") String prevSnapshotUrl, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<PageList> getPageRangesDiffNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("timeout") Integer timeout, @QueryParam("prevsnapshot") String prevsnapshot,
            @HeaderParam("x-ms-previous-snapshot-url") String prevSnapshotUrl, @HeaderParam("x-ms-range") String range,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsResizeHeaders, Void>> resize(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> resizeNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsResizeHeaders, Void> resizeSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> resizeNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-blob-content-length") long blobContentLength,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsUpdateSequenceNumberHeaders, Void>> updateSequenceNumber(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @PathParam("blob") String blob, @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-sequence-number-action") SequenceNumberActionType sequenceNumberAction,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> updateSequenceNumberNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-sequence-number-action") SequenceNumberActionType sequenceNumberAction,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsUpdateSequenceNumberHeaders, Void> updateSequenceNumberSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-sequence-number-action") SequenceNumberActionType sequenceNumberAction,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> updateSequenceNumberNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-sequence-number-action") SequenceNumberActionType sequenceNumberAction,
            @HeaderParam("x-ms-blob-sequence-number") Long blobSequenceNumber,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<PageBlobsCopyIncrementalHeaders, Void>> copyIncremental(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> copyIncrementalNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<PageBlobsCopyIncrementalHeaders, Void> copyIncrementalSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> copyIncrementalNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsCreateHeaders, Void>> createWithResponseAsync(String containerName, String blob,
        long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> createWithResponseAsync(containerName, blob, contentLength, blobContentLength,
                timeout, tier, metadata, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags,
                blobSequenceNumber, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode,
                legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsCreateHeaders, Void>> createWithResponseAsync(String containerName, String blob,
        long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "PageBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service
            .create(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength, tier, contentType,
                contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength,
                blobSequenceNumber, this.client.getVersion(), requestId, blobTagsString,
                immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, String blob, long contentLength, long blobContentLength,
        Integer timeout, PremiumPageBlobAccessTier tier, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, Long blobSequenceNumber, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return createWithResponseAsync(containerName, blob, contentLength, blobContentLength, timeout, tier, metadata,
            leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo,
            encryptionScopeParam).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, String blob, long contentLength, long blobContentLength,
        Integer timeout, PremiumPageBlobAccessTier tier, Map<String, String> metadata, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, Long blobSequenceNumber, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return createWithResponseAsync(containerName, blob, contentLength, blobContentLength, timeout, tier, metadata,
            leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo,
            encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> createNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                blobContentLength, timeout, tier, metadata, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch,
                ifNoneMatch, ifTags, blobSequenceNumber, requestId, blobTagsString, immutabilityPolicyExpiry,
                immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "PageBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service
            .createNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength, tier,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength,
                blobSequenceNumber, this.client.getVersion(), requestId, blobTagsString,
                immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsCreateHeaders, Void> createWithResponse(String containerName, String blob,
        long contentLength, long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier,
        Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "PageBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.createSync(this.client.getUrl(), containerName, blob, blobType, timeout, contentLength, tier,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength,
                blobSequenceNumber, this.client.getVersion(), requestId, blobTagsString,
                immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void create(String containerName, String blob, long contentLength, long blobContentLength, Integer timeout,
        PremiumPageBlobAccessTier tier, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        createWithResponse(containerName, blob, contentLength, blobContentLength, timeout, tier, metadata, leaseId,
            ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, blobHttpHeaders, cpkInfo,
            encryptionScopeParam, Context.NONE);
    }

    /**
     * The Create operation creates a new page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param tier Optional. Indicates the tier to be set on the page blob.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        long blobContentLength, Integer timeout, PremiumPageBlobAccessTier tier, Map<String, String> metadata,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "PageBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.createNoCustomHeadersSync(this.client.getUrl(), containerName, blob, blobType, timeout,
                contentLength, tier, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl,
                metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                blobContentLength, blobSequenceNumber, this.client.getVersion(), requestId, blobTagsString,
                immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPagesWithResponseAsync(String containerName,
        String blob, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesWithResponseAsync(containerName, blob, contentLength, body,
                transactionalContentMD5, transactionalContentCrc64, timeout, range, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPagesWithResponseAsync(String containerName,
        String blob, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .uploadPages(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return uploadPagesWithResponseAsync(containerName, blob, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return uploadPagesWithResponseAsync(containerName, blob, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                body, transactionalContentMD5, transactionalContentCrc64, timeout, range, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .uploadPagesNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPagesWithResponseAsync(String containerName,
        String blob, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesWithResponseAsync(containerName, blob, contentLength, body,
                transactionalContentMD5, transactionalContentCrc64, timeout, range, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesHeaders, Void>> uploadPagesWithResponseAsync(String containerName,
        String blob, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .uploadPages(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesAsync(String containerName, String blob, long contentLength, BinaryData body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return uploadPagesWithResponseAsync(containerName, blob, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesAsync(String containerName, String blob, long contentLength, BinaryData body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return uploadPagesWithResponseAsync(containerName, blob, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                body, transactionalContentMD5, transactionalContentCrc64, timeout, range, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, structuredBodyType, structuredContentLength,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .uploadPagesNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsUploadPagesHeaders, Void> uploadPagesWithResponse(String containerName, String blob,
        long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "update";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.uploadPagesSync(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void uploadPages(String containerName, String blob, long contentLength, BinaryData body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        uploadPagesWithResponse(containerName, blob, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, requestId, structuredBodyType, structuredContentLength, cpkInfo, encryptionScopeParam,
            Context.NONE);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> uploadPagesNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout,
        String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "update";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.uploadPagesNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, pageWrite,
                contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, range,
                leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsClearPagesHeaders, Void>> clearPagesWithResponseAsync(String containerName,
        String blob, long contentLength, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> clearPagesWithResponseAsync(containerName, blob, contentLength, timeout, range,
                leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsClearPagesHeaders, Void>> clearPagesWithResponseAsync(String containerName,
        String blob, long contentLength, Integer timeout, String range, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "page";
        final String pageWrite = "clear";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .clearPages(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength, timeout, range,
                leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearPagesAsync(String containerName, String blob, long contentLength, Integer timeout,
        String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return clearPagesWithResponseAsync(containerName, blob, contentLength, timeout, range, leaseId,
            ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> clearPagesAsync(String containerName, String blob, long contentLength, Integer timeout,
        String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        return clearPagesWithResponseAsync(containerName, blob, contentLength, timeout, range, leaseId,
            ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> clearPagesNoCustomHeadersWithResponseAsync(containerName, blob, contentLength,
                timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan,
                ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
                cpkInfo, encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> clearPagesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "page";
        final String pageWrite = "clear";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .clearPagesNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                timeout, range, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsClearPagesHeaders, Void> clearPagesWithResponse(String containerName, String blob,
        long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "clear";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.clearPagesSync(this.client.getUrl(), containerName, blob, comp, pageWrite, contentLength,
                timeout, range, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void clearPages(String containerName, String blob, long contentLength, Integer timeout, String range,
        String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        clearPagesWithResponse(containerName, blob, contentLength, timeout, range, leaseId,
            ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Clear Pages operation clears a set of pages from a page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> clearPagesNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "clear";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.clearPagesNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, pageWrite,
                contentLength, timeout, range, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesFromURLHeaders, Void>> uploadPagesFromURLWithResponseAsync(
        String containerName, String blob, String sourceUrl, String sourceRange, long contentLength, String range,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesFromURLWithResponseAsync(containerName, blob, sourceUrl, sourceRange,
                contentLength, range, sourceContentMD5, sourceContentcrc64, timeout, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince,
                sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, fileRequestIntent, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUploadPagesFromURLHeaders, Void>> uploadPagesFromURLWithResponseAsync(
        String containerName, String blob, String sourceUrl, String sourceRange, long contentLength, String range,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId,
        Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service
            .uploadPagesFromURL(this.client.getUrl(), containerName, blob, comp, pageWrite, sourceUrl, sourceRange,
                sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, ifSequenceNumberLessThanOrEqualTo,
                ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted,
                sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization,
                fileRequestIntent, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesFromURLAsync(String containerName, String blob, String sourceUrl, String sourceRange,
        long contentLength, String range, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return uploadPagesFromURLWithResponseAsync(containerName, blob, sourceUrl, sourceRange, contentLength, range,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId,
            copySourceAuthorization, fileRequestIntent, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadPagesFromURLAsync(String containerName, String blob, String sourceUrl, String sourceRange,
        long contentLength, String range, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        return uploadPagesFromURLWithResponseAsync(containerName, blob, sourceUrl, sourceRange, contentLength, range,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId,
            copySourceAuthorization, fileRequestIntent, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> uploadPagesFromURLNoCustomHeadersWithResponseAsync(containerName, blob, sourceUrl,
                sourceRange, contentLength, range, sourceContentMD5, sourceContentcrc64, timeout, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince,
                sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, fileRequestIntent, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadPagesFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        final String comp = "page";
        final String pageWrite = "update";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service
            .uploadPagesFromURLNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, pageWrite, sourceUrl,
                sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, fileRequestIntent, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsUploadPagesFromURLHeaders, Void> uploadPagesFromURLWithResponse(String containerName,
        String blob, String sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "update";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.uploadPagesFromURLSync(this.client.getUrl(), containerName, blob, comp, pageWrite, sourceUrl,
                sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, contentLength, timeout, range,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId,
                ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, fileRequestIntent, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void uploadPagesFromURL(String containerName, String blob, String sourceUrl, String sourceRange,
        long contentLength, String range, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan,
        Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        uploadPagesFromURLWithResponse(containerName, blob, sourceUrl, sourceRange, contentLength, range,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, ifSequenceNumberLessThanOrEqualTo,
            ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, requestId,
            copySourceAuthorization, fileRequestIntent, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Upload Pages operation writes a range of pages to a page blob where the contents are read from a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range. The length of this range should match the
     * ContentLength header and x-ms-range/Range destination range header.
     * @param contentLength The length of the request.
     * @param range The range of bytes to which the source range would be written. The range should be 512 aligned and
     * range-end is required.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifSequenceNumberLessThanOrEqualTo Specify this header value to operate only on a blob if it has a sequence
     * number less than or equal to the specified.
     * @param ifSequenceNumberLessThan Specify this header value to operate only on a blob if it has a sequence number
     * less than the specified.
     * @param ifSequenceNumberEqualTo Specify this header value to operate only on a blob if it has the specified
     * sequence number.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param fileRequestIntent Valid value is backup.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> uploadPagesFromURLNoCustomHeadersWithResponse(String containerName, String blob,
        String sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, Long ifSequenceNumberLessThanOrEqualTo,
        Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        FileShareTokenIntent fileRequestIntent, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        try {
            final String comp = "page";
            final String pageWrite = "update";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.uploadPagesFromURLNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp,
                pageWrite, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted,
                contentLength, timeout, range, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
                leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, fileRequestIntent, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsGetPageRangesHeaders, PageList>> getPageRangesWithResponseAsync(
        String containerName, String blob, String snapshot, Integer timeout, String range, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String marker, Integer maxresults) {
        return FluxUtil
            .withContext(context -> getPageRangesWithResponseAsync(containerName, blob, snapshot, timeout, range,
                leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker,
                maxresults, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsGetPageRangesHeaders, PageList>> getPageRangesWithResponseAsync(
        String containerName, String blob, String snapshot, Integer timeout, String range, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String marker, Integer maxresults, Context context) {
        final String comp = "pagelist";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .getPageRanges(this.client.getUrl(), containerName, blob, comp, snapshot, timeout, range, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, marker, maxresults, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PageList> getPageRangesAsync(String containerName, String blob, String snapshot, Integer timeout,
        String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String marker, Integer maxresults) {
        return getPageRangesWithResponseAsync(containerName, blob, snapshot, timeout, range, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker, maxresults)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PageList> getPageRangesAsync(String containerName, String blob, String snapshot, Integer timeout,
        String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String marker, Integer maxresults, Context context) {
        return getPageRangesWithResponseAsync(containerName, blob, snapshot, timeout, range, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker, maxresults, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults) {
        return FluxUtil
            .withContext(context -> getPageRangesNoCustomHeadersWithResponseAsync(containerName, blob, snapshot,
                timeout, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
                marker, maxresults, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults, Context context) {
        final String comp = "pagelist";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .getPageRangesNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, snapshot, timeout, range,
                leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, marker, maxresults, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsGetPageRangesHeaders, PageList> getPageRangesWithResponse(String containerName,
        String blob, String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults, Context context) {
        try {
            final String comp = "pagelist";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.getPageRangesSync(this.client.getUrl(), containerName, blob, comp, snapshot, timeout, range,
                leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, marker, maxresults, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PageList getPageRanges(String containerName, String blob, String snapshot, Integer timeout, String range,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String marker, Integer maxresults) {
        try {
            return getPageRangesWithResponse(containerName, blob, snapshot, timeout, range, leaseId, ifModifiedSince,
                ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker, maxresults, Context.NONE)
                    .getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Page Ranges operation returns the list of valid page ranges for a page blob, version or snapshot of a
     * page blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PageList> getPageRangesNoCustomHeadersWithResponse(String containerName, String blob,
        String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults, Context context) {
        try {
            final String comp = "pagelist";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.getPageRangesNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, snapshot,
                timeout, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch,
                ifTags, this.client.getVersion(), requestId, marker, maxresults, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList>> getPageRangesDiffWithResponseAsync(
        String containerName, String blob, String snapshot, Integer timeout, String prevsnapshot,
        String prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults) {
        return FluxUtil
            .withContext(context -> getPageRangesDiffWithResponseAsync(containerName, blob, snapshot, timeout,
                prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
                ifTags, requestId, marker, maxresults, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList>> getPageRangesDiffWithResponseAsync(
        String containerName, String blob, String snapshot, Integer timeout, String prevsnapshot,
        String prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults, Context context) {
        final String comp = "pagelist";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .getPageRangesDiff(this.client.getUrl(), containerName, blob, comp, snapshot, timeout, prevsnapshot,
                prevSnapshotUrl, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch,
                ifNoneMatch, ifTags, this.client.getVersion(), requestId, marker, maxresults, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PageList> getPageRangesDiffAsync(String containerName, String blob, String snapshot, Integer timeout,
        String prevsnapshot, String prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults) {
        return getPageRangesDiffWithResponseAsync(containerName, blob, snapshot, timeout, prevsnapshot, prevSnapshotUrl,
            range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker,
            maxresults).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PageList> getPageRangesDiffAsync(String containerName, String blob, String snapshot, Integer timeout,
        String prevsnapshot, String prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults, Context context) {
        return getPageRangesDiffWithResponseAsync(containerName, blob, snapshot, timeout, prevsnapshot, prevSnapshotUrl,
            range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker,
            maxresults, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesDiffNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String snapshot, Integer timeout, String prevsnapshot, String prevSnapshotUrl, String range, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String marker, Integer maxresults) {
        return FluxUtil
            .withContext(context -> getPageRangesDiffNoCustomHeadersWithResponseAsync(containerName, blob, snapshot,
                timeout, prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch,
                ifNoneMatch, ifTags, requestId, marker, maxresults, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesDiffNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String snapshot, Integer timeout, String prevsnapshot, String prevSnapshotUrl, String range, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String marker, Integer maxresults, Context context) {
        final String comp = "pagelist";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .getPageRangesDiffNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, snapshot, timeout,
                prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, marker, maxresults, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList> getPageRangesDiffWithResponse(String containerName,
        String blob, String snapshot, Integer timeout, String prevsnapshot, String prevSnapshotUrl, String range,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String marker, Integer maxresults, Context context) {
        try {
            final String comp = "pagelist";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.getPageRangesDiffSync(this.client.getUrl(), containerName, blob, comp, snapshot, timeout,
                prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, marker, maxresults, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PageList getPageRangesDiff(String containerName, String blob, String snapshot, Integer timeout,
        String prevsnapshot, String prevSnapshotUrl, String range, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String marker, Integer maxresults) {
        try {
            return getPageRangesDiffWithResponse(containerName, blob, snapshot, timeout, prevsnapshot, prevSnapshotUrl,
                range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, marker,
                maxresults, Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The Get Page Ranges Diff operation returns the list of valid page ranges for a page blob that were
     * changed between target blob and previous snapshot or version.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/creating-a-snapshot-of-a-blob"&gt;Creating a Snapshot
     * of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param prevsnapshot Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that
     * specifies that the response will contain only pages that were changed between target blob and previous snapshot.
     * Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long as the snapshot
     * specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only
     * for blobs created on or after January 1, 2016.
     * @param prevSnapshotUrl Optional. This header is only supported in service versions 2019-04-19 and after and
     * specifies the URL of a previous snapshot of the target blob. The response will only contain pages that were
     * changed between the target blob and its previous snapshot.
     * @param range Return only the bytes of the blob in the specified range.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of pages along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PageList> getPageRangesDiffNoCustomHeadersWithResponse(String containerName, String blob,
        String snapshot, Integer timeout, String prevsnapshot, String prevSnapshotUrl, String range, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String marker, Integer maxresults, Context context) {
        try {
            final String comp = "pagelist";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.getPageRangesDiffNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp,
                snapshot, timeout, prevsnapshot, prevSnapshotUrl, range, leaseId, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, marker,
                maxresults, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsResizeHeaders, Void>> resizeWithResponseAsync(String containerName, String blob,
        long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> resizeWithResponseAsync(containerName, blob, blobContentLength, timeout, leaseId,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsResizeHeaders, Void>> resizeWithResponseAsync(String containerName, String blob,
        long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "properties";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .resize(this.client.getUrl(), containerName, blob, comp, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resizeAsync(String containerName, String blob, long blobContentLength, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return resizeWithResponseAsync(containerName, blob, blobContentLength, timeout, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resizeAsync(String containerName, String blob, long blobContentLength, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam,
        Context context) {
        return resizeWithResponseAsync(containerName, blob, blobContentLength, timeout, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resizeNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return FluxUtil
            .withContext(context -> resizeNoCustomHeadersWithResponseAsync(containerName, blob, blobContentLength,
                timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo,
                encryptionScopeParam, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resizeNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "properties";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .resizeNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsResizeHeaders, Void> resizeWithResponse(String containerName, String blob,
        long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "properties";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.resizeSync(this.client.getUrl(), containerName, blob, comp, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resize(String containerName, String blob, long blobContentLength, Integer timeout, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        resizeWithResponse(containerName, blob, blobContentLength, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince,
            ifMatch, ifNoneMatch, ifTags, requestId, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * Resize the Blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blobContentLength This header specifies the maximum size for the page blob, up to 1 TB. The page blob size
     * must be aligned to a 512-byte boundary.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resizeNoCustomHeadersWithResponse(String containerName, String blob, long blobContentLength,
        Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "properties";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.resizeNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, timeout, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, blobContentLength, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUpdateSequenceNumberHeaders, Void>> updateSequenceNumberWithResponseAsync(
        String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId) {
        return FluxUtil
            .withContext(context -> updateSequenceNumberWithResponseAsync(containerName, blob, sequenceNumberAction,
                timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber,
                requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsUpdateSequenceNumberHeaders, Void>> updateSequenceNumberWithResponseAsync(
        String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId, Context context) {
        final String comp = "properties";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .updateSequenceNumber(this.client.getUrl(), containerName, blob, comp, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateSequenceNumberAsync(String containerName, String blob,
        SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId) {
        return updateSequenceNumberWithResponseAsync(containerName, blob, sequenceNumberAction, timeout, leaseId,
            ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateSequenceNumberAsync(String containerName, String blob,
        SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId, Context context) {
        return updateSequenceNumberWithResponseAsync(containerName, blob, sequenceNumberAction, timeout, leaseId,
            ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateSequenceNumberNoCustomHeadersWithResponseAsync(String containerName, String blob,
        SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId) {
        return FluxUtil
            .withContext(context -> updateSequenceNumberNoCustomHeadersWithResponseAsync(containerName, blob,
                sequenceNumberAction, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
                ifTags, blobSequenceNumber, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateSequenceNumberNoCustomHeadersWithResponseAsync(String containerName, String blob,
        SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId, Context context) {
        final String comp = "properties";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .updateSequenceNumberNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsUpdateSequenceNumberHeaders, Void> updateSequenceNumberWithResponse(
        String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId, Context context) {
        try {
            final String comp = "properties";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.updateSequenceNumberSync(this.client.getUrl(), containerName, blob, comp, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateSequenceNumber(String containerName, String blob, SequenceNumberActionType sequenceNumberAction,
        Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber, String requestId) {
        updateSequenceNumberWithResponse(containerName, blob, sequenceNumberAction, timeout, leaseId, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, blobSequenceNumber, requestId, Context.NONE);
    }

    /**
     * Update the sequence number of the blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param sequenceNumberAction Required if the x-ms-blob-sequence-number header is set for the request. This
     * property applies to page blobs only. This property indicates how the service should modify the blob's sequence
     * number.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param blobSequenceNumber Set for page blobs only. The sequence number is a user-controlled value that you can
     * use to track requests. The value of the sequence number must be between 0 and 2^63 - 1.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateSequenceNumberNoCustomHeadersWithResponse(String containerName, String blob,
        SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, Long blobSequenceNumber,
        String requestId, Context context) {
        try {
            final String comp = "properties";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.updateSequenceNumberNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp,
                timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sequenceNumberAction, blobSequenceNumber, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsCopyIncrementalHeaders, Void>> copyIncrementalWithResponseAsync(
        String containerName, String blob, String copySource, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId) {
        return FluxUtil
            .withContext(context -> copyIncrementalWithResponseAsync(containerName, blob, copySource, timeout,
                ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<PageBlobsCopyIncrementalHeaders, Void>> copyIncrementalWithResponseAsync(
        String containerName, String blob, String copySource, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        Context context) {
        final String comp = "incrementalcopy";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .copyIncremental(this.client.getUrl(), containerName, blob, comp, timeout, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyIncrementalAsync(String containerName, String blob, String copySource, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId) {
        return copyIncrementalWithResponseAsync(containerName, blob, copySource, timeout, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyIncrementalAsync(String containerName, String blob, String copySource, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, Context context) {
        return copyIncrementalWithResponseAsync(containerName, blob, copySource, timeout, ifModifiedSince,
            ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyIncrementalNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String copySource, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId) {
        return FluxUtil
            .withContext(context -> copyIncrementalNoCustomHeadersWithResponseAsync(containerName, blob, copySource,
                timeout, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyIncrementalNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String copySource, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        final String comp = "incrementalcopy";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .copyIncrementalNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<PageBlobsCopyIncrementalHeaders, Void> copyIncrementalWithResponse(String containerName,
        String blob, String copySource, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        Context context) {
        try {
            final String comp = "incrementalcopy";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.copyIncrementalSync(this.client.getUrl(), containerName, blob, comp, timeout,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void copyIncremental(String containerName, String blob, String copySource, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId) {
        copyIncrementalWithResponse(containerName, blob, copySource, timeout, ifModifiedSince, ifUnmodifiedSince,
            ifMatch, ifNoneMatch, ifTags, requestId, Context.NONE);
    }

    /**
     * The Copy Incremental operation copies a snapshot of the source page blob to a destination page blob. The snapshot
     * is copied such that only the differential changes between the previously copied snapshot are transferred to the
     * destination. The copied snapshots are complete copies of the original snapshot and can be read or copied from as
     * usual. This API is supported since REST version 2016-05-31.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://learn.microsoft.com/rest/api/storageservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> copyIncrementalNoCustomHeadersWithResponse(String containerName, String blob,
        String copySource, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        try {
            final String comp = "incrementalcopy";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.copyIncrementalNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, timeout,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }
}
