// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

/**
 * Defines values for BlockListType.
 */
public enum BlockListType {
    /**
     * Enum value committed.
     */
    COMMITTED("committed"),

    /**
     * Enum value uncommitted.
     */
    UNCOMMITTED("uncommitted"),

    /**
     * Enum value all.
     */
    ALL("all");

    /**
     * The actual serialized value for a BlockListType instance.
     */
    private final String value;

    BlockListType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a BlockListType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed BlockListType object, or null if unable to parse.
     */
    public static BlockListType fromString(String value) {
        if (value == null) {
            return null;
        }
        BlockListType[] items = BlockListType.values();
        for (BlockListType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
