// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.models.BlobSignedIdentifierWrapper;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.ContainersAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersCreateHeaders;
import com.azure.storage.blob.implementation.models.ContainersDeleteHeaders;
import com.azure.storage.blob.implementation.models.ContainersFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersReleaseLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersRenameHeaders;
import com.azure.storage.blob.implementation.models.ContainersRenewLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersRestoreHeaders;
import com.azure.storage.blob.implementation.models.ContainersSetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainersSetMetadataHeaders;
import com.azure.storage.blob.implementation.models.ContainersSubmitBatchHeaders;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.FilterBlobsIncludeItem;
import com.azure.storage.blob.implementation.models.ListBlobsFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.PublicAccessType;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Containers.
 */
public final class ContainersImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final ContainersService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureBlobStorageImpl client;

    /**
     * Initializes an instance of ContainersImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContainersImpl(AzureBlobStorageImpl client) {
        this.service
            = RestProxy.create(ContainersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureBlobStorageContainers to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureBlobStorageCont")
    public interface ContainersService {

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersCreateHeaders, Void>> create(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-default-encryption-scope") String defaultEncryptionScope,
            @HeaderParam("x-ms-deny-encryption-scope-override") Boolean encryptionScopeOverridePrevented,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> createNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-default-encryption-scope") String defaultEncryptionScope,
            @HeaderParam("x-ms-deny-encryption-scope-override") Boolean encryptionScopeOverridePrevented,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersCreateHeaders, Void> createSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-default-encryption-scope") String defaultEncryptionScope,
            @HeaderParam("x-ms-deny-encryption-scope-override") Boolean encryptionScopeOverridePrevented,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> createNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-default-encryption-scope") String defaultEncryptionScope,
            @HeaderParam("x-ms-deny-encryption-scope-override") Boolean encryptionScopeOverridePrevented,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getProperties(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersGetPropertiesHeaders, Void> getPropertiesSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> getPropertiesNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersDeleteHeaders, Void>> delete(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> deleteNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersDeleteHeaders, Void> deleteSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> deleteNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadata(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersSetMetadataHeaders, Void> setMetadataSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> setMetadataNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-meta-") Map<String, String> metadata,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersGetAccessPolicyHeaders, BlobSignedIdentifierWrapper>> getAccessPolicy(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<BlobSignedIdentifierWrapper>> getAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersGetAccessPolicyHeaders, BlobSignedIdentifierWrapper> getAccessPolicySync(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<BlobSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BlobSignedIdentifierWrapper containerAcl,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BlobSignedIdentifierWrapper containerAcl,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BlobSignedIdentifierWrapper containerAcl,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> setAccessPolicyNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-public-access") PublicAccessType access,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BlobSignedIdentifierWrapper containerAcl,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersRestoreHeaders, Void>> restore(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-container-name") String deletedContainerName,
            @HeaderParam("x-ms-deleted-container-version") String deletedContainerVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> restoreNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-container-name") String deletedContainerName,
            @HeaderParam("x-ms-deleted-container-version") String deletedContainerVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersRestoreHeaders, Void> restoreSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-container-name") String deletedContainerName,
            @HeaderParam("x-ms-deleted-container-version") String deletedContainerVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> restoreNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-deleted-container-name") String deletedContainerName,
            @HeaderParam("x-ms-deleted-container-version") String deletedContainerVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersRenameHeaders, Void>> rename(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-container-name") String sourceContainerName,
            @HeaderParam("x-ms-source-lease-id") String sourceLeaseId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> renameNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-container-name") String sourceContainerName,
            @HeaderParam("x-ms-source-lease-id") String sourceLeaseId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersRenameHeaders, Void> renameSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-container-name") String sourceContainerName,
            @HeaderParam("x-ms-source-lease-id") String sourceLeaseId, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> renameNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-container-name") String sourceContainerName,
            @HeaderParam("x-ms-source-lease-id") String sourceLeaseId, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept, Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept, Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BinaryData body, @HeaderParam("Accept") String accept, Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BinaryData body, @HeaderParam("Accept") String accept, Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersSubmitBatchHeaders, InputStream> submitBatchSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BinaryData body, @HeaderParam("Accept") String accept, Context context);

        @Post("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<InputStream> submitBatchNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-Type") String multipartContentType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @BodyParam("application/xml") BinaryData body, @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobs(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @QueryParam("where") String where, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @QueryParam("where") String where, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment> filterBlobsSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @QueryParam("where") String where, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<FilterBlobSegment> filterBlobsNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @QueryParam("where") String where, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLease(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> acquireLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersAcquireLeaseHeaders, Void> acquireLeaseSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> acquireLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-duration") Integer duration,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLease(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> releaseLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersReleaseLeaseHeaders, Void> releaseLeaseSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> releaseLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLease(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> renewLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersRenewLeaseHeaders, Void> renewLeaseSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> renewLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLease(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> breakLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersBreakLeaseHeaders, Void> breakLeaseSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> breakLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-break-period") Integer breakPeriod,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLease(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> changeLeaseNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersChangeLeaseHeaders, Void> changeLeaseSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> changeLeaseNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("comp") String comp,
            @QueryParam("restype") String restype, @HeaderParam("x-ms-lease-action") String action,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-proposed-lease-id") String proposedLeaseId,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>> listBlobFlatSegment(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("prefix") String prefix, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse> listBlobFlatSegmentSync(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
            @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<ListBlobsFlatSegmentResponse> listBlobFlatSegmentNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("prefix") String prefix, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>>
            listBlobHierarchySegment(@HostParam("url") String url, @PathParam("containerName") String containerName,
                @QueryParam("restype") String restype, @QueryParam("comp") String comp,
                @QueryParam("prefix") String prefix, @QueryParam("delimiter") String delimiter,
                @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
                @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeaders(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("delimiter") String delimiter, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>
            listBlobHierarchySegmentSync(@HostParam("url") String url, @PathParam("containerName") String containerName,
                @QueryParam("restype") String restype, @QueryParam("comp") String comp,
                @QueryParam("prefix") String prefix, @QueryParam("delimiter") String delimiter,
                @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults,
                @QueryParam("include") String include, @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
                @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentNoCustomHeadersSync(
            @HostParam("url") String url, @PathParam("containerName") String containerName,
            @QueryParam("restype") String restype, @QueryParam("comp") String comp, @QueryParam("prefix") String prefix,
            @QueryParam("delimiter") String delimiter, @QueryParam("marker") String marker,
            @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include,
            @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>> getAccountInfo(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> getAccountInfoNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<ContainersGetAccountInfoHeaders, Void> getAccountInfoSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> getAccountInfoNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @QueryParam("restype") String restype,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersCreateHeaders, Void>> createWithResponseAsync(String containerName,
        Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope) {
        return FluxUtil
            .withContext(context -> createWithResponseAsync(containerName, timeout, metadata, access, requestId,
                blobContainerEncryptionScope, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersCreateHeaders, Void>> createWithResponseAsync(String containerName,
        Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal
                = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return service
            .create(this.client.getUrl(), containerName, restype, timeout, metadata, access, this.client.getVersion(),
                requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, Integer timeout, Map<String, String> metadata,
        PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        return createWithResponseAsync(containerName, timeout, metadata, access, requestId,
            blobContainerEncryptionScope)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, Integer timeout, Map<String, String> metadata,
        PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope,
        Context context) {
        return createWithResponseAsync(containerName, timeout, metadata, access, requestId,
            blobContainerEncryptionScope, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope) {
        return FluxUtil
            .withContext(context -> createNoCustomHeadersWithResponseAsync(containerName, timeout, metadata, access,
                requestId, blobContainerEncryptionScope, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal
                = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return service
            .createNoCustomHeaders(this.client.getUrl(), containerName, restype, timeout, metadata, access,
                this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersCreateHeaders, Void> createWithResponse(String containerName, Integer timeout,
        Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            String defaultEncryptionScopeInternal = null;
            if (blobContainerEncryptionScope != null) {
                defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
            }
            String defaultEncryptionScope = defaultEncryptionScopeInternal;
            Boolean encryptionScopeOverridePreventedInternal = null;
            if (blobContainerEncryptionScope != null) {
                encryptionScopeOverridePreventedInternal
                    = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
            }
            Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
            return service.createSync(this.client.getUrl(), containerName, restype, timeout, metadata, access,
                this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void create(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access,
        String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        createWithResponse(containerName, timeout, metadata, access, requestId, blobContainerEncryptionScope,
            Context.NONE);
    }

    /**
     * creates a new container under the specified account. If the container with the same name already exists, the
     * operation fails.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobContainerEncryptionScope Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String containerName, Integer timeout,
        Map<String, String> metadata, PublicAccessType access, String requestId,
        BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            String defaultEncryptionScopeInternal = null;
            if (blobContainerEncryptionScope != null) {
                defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
            }
            String defaultEncryptionScope = defaultEncryptionScopeInternal;
            Boolean encryptionScopeOverridePreventedInternal = null;
            if (blobContainerEncryptionScope != null) {
                encryptionScopeOverridePreventedInternal
                    = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
            }
            Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
            return service.createNoCustomHeadersSync(this.client.getUrl(), containerName, restype, timeout, metadata,
                access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented,
                accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String containerName,
        Integer timeout, String leaseId, String requestId) {
        return FluxUtil
            .withContext(context -> getPropertiesWithResponseAsync(containerName, timeout, leaseId, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String containerName,
        Integer timeout, String leaseId, String requestId, Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        return service
            .getProperties(this.client.getUrl(), containerName, restype, timeout, leaseId, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        return getPropertiesWithResponseAsync(containerName, timeout, leaseId, requestId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String containerName, Integer timeout, String leaseId, String requestId,
        Context context) {
        return getPropertiesWithResponseAsync(containerName, timeout, leaseId, requestId, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, String requestId) {
        return FluxUtil
            .withContext(context -> getPropertiesNoCustomHeadersWithResponseAsync(containerName, timeout, leaseId,
                requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, String requestId, Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        return service
            .getPropertiesNoCustomHeaders(this.client.getUrl(), containerName, restype, timeout, leaseId,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersGetPropertiesHeaders, Void> getPropertiesWithResponse(String containerName,
        Integer timeout, String leaseId, String requestId, Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            return service.getPropertiesSync(this.client.getUrl(), containerName, restype, timeout, leaseId,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void getProperties(String containerName, Integer timeout, String leaseId, String requestId) {
        getPropertiesWithResponse(containerName, timeout, leaseId, requestId, Context.NONE);
    }

    /**
     * returns all user-defined metadata and system properties for the specified container. The data returned does not
     * include the container's list of blobs.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String containerName, Integer timeout,
        String leaseId, String requestId, Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            return service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), containerName, restype, timeout,
                leaseId, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersDeleteHeaders, Void>> deleteWithResponseAsync(String containerName,
        Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> deleteWithResponseAsync(containerName, timeout, leaseId, ifModifiedSince,
                ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersDeleteHeaders, Void>> deleteWithResponseAsync(String containerName,
        Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .delete(this.client.getUrl(), containerName, restype, timeout, leaseId, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        return deleteWithResponseAsync(containerName, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return deleteWithResponseAsync(containerName, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> deleteNoCustomHeadersWithResponseAsync(containerName, timeout, leaseId,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        final String restype = "container";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service.deleteNoCustomHeaders(this.client.getUrl(), containerName, restype, timeout, leaseId,
            ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersDeleteHeaders, Void> deleteWithResponse(String containerName, Integer timeout,
        String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.deleteSync(this.client.getUrl(), containerName, restype, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        deleteWithResponse(containerName, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId,
            Context.NONE);
    }

    /**
     * operation marks the specified container for deletion. The container and any blobs contained within it are later
     * deleted during garbage collection.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String containerName, Integer timeout, String leaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        try {
            final String restype = "container";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.deleteNoCustomHeadersSync(this.client.getUrl(), containerName, restype, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String containerName,
        Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> setMetadataWithResponseAsync(containerName, timeout, leaseId, metadata,
                ifModifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String containerName,
        Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId,
        Context context) {
        final String restype = "container";
        final String comp = "metadata";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return service
            .setMetadata(this.client.getUrl(), containerName, restype, comp, timeout, leaseId, metadata,
                ifModifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String containerName, Integer timeout, String leaseId,
        Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        return setMetadataWithResponseAsync(containerName, timeout, leaseId, metadata, ifModifiedSince, requestId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String containerName, Integer timeout, String leaseId,
        Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        return setMetadataWithResponseAsync(containerName, timeout, leaseId, metadata, ifModifiedSince, requestId,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> setMetadataNoCustomHeadersWithResponseAsync(containerName, timeout, leaseId,
                metadata, ifModifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId,
        Context context) {
        final String restype = "container";
        final String comp = "metadata";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return service
            .setMetadataNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout, leaseId, metadata,
                ifModifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersSetMetadataHeaders, Void> setMetadataWithResponse(String containerName,
        Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId,
        Context context) {
        try {
            final String restype = "container";
            final String comp = "metadata";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            return service.setMetadataSync(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setMetadata(String containerName, Integer timeout, String leaseId, Map<String, String> metadata,
        OffsetDateTime ifModifiedSince, String requestId) {
        setMetadataWithResponse(containerName, timeout, leaseId, metadata, ifModifiedSince, requestId, Context.NONE);
    }

    /**
     * operation sets one or more user-defined name-value pairs for the specified container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String containerName, Integer timeout, String leaseId,
        Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "metadata";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            return service.setMetadataNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp, timeout,
                leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccessPolicyHeaders, BlobSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        return FluxUtil
            .withContext(
                context -> getAccessPolicyWithResponseAsync(containerName, timeout, leaseId, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccessPolicyHeaders, BlobSignedIdentifierWrapper>>
        getAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId,
            Context context) {
        final String restype = "container";
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicy(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BlobSignedIdentifierWrapper> getAccessPolicyAsync(String containerName, Integer timeout, String leaseId,
        String requestId) {
        return getAccessPolicyWithResponseAsync(containerName, timeout, leaseId, requestId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BlobSignedIdentifierWrapper> getAccessPolicyAsync(String containerName, Integer timeout, String leaseId,
        String requestId, Context context) {
        return getAccessPolicyWithResponseAsync(containerName, timeout, leaseId, requestId, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BlobSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(
        String containerName, Integer timeout, String leaseId, String requestId) {
        return FluxUtil
            .withContext(context -> getAccessPolicyNoCustomHeadersWithResponseAsync(containerName, timeout, leaseId,
                requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BlobSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(
        String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        final String restype = "container";
        final String comp = "acl";
        final String accept = "application/xml";
        return service
            .getAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersGetAccessPolicyHeaders, BlobSignedIdentifierWrapper> getAccessPolicyWithResponse(
        String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicySync(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BlobSignedIdentifierWrapper getAccessPolicy(String containerName, Integer timeout, String leaseId,
        String requestId) {
        try {
            return getAccessPolicyWithResponse(containerName, timeout, leaseId, requestId, Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * gets the permissions for the specified container. The permissions indicate whether container data may be accessed
     * publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the permissions for the specified container along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BlobSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersWithResponse(String containerName,
        Integer timeout, String leaseId, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "acl";
            final String accept = "application/xml";
            return service.getAccessPolicyNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp,
                timeout, leaseId, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(
        String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl) {
        return FluxUtil
            .withContext(context -> setAccessPolicyWithResponseAsync(containerName, timeout, leaseId, access,
                ifModifiedSince, ifUnmodifiedSince, requestId, containerAcl, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(
        String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        final String restype = "container";
        final String comp = "acl";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        BlobSignedIdentifierWrapper containerAclConverted = new BlobSignedIdentifierWrapper(containerAcl);
        return service
            .setAccessPolicy(this.client.getUrl(), containerName, restype, comp, timeout, leaseId, access,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId,
                containerAclConverted, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String containerName, Integer timeout, String leaseId,
        PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        List<BlobSignedIdentifier> containerAcl) {
        return setAccessPolicyWithResponseAsync(containerName, timeout, leaseId, access, ifModifiedSince,
            ifUnmodifiedSince, requestId, containerAcl)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String containerName, Integer timeout, String leaseId,
        PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        List<BlobSignedIdentifier> containerAcl, Context context) {
        return setAccessPolicyWithResponseAsync(containerName, timeout, leaseId, access, ifModifiedSince,
            ifUnmodifiedSince, requestId, containerAcl, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, List<BlobSignedIdentifier> containerAcl) {
        return FluxUtil
            .withContext(context -> setAccessPolicyNoCustomHeadersWithResponseAsync(containerName, timeout, leaseId,
                access, ifModifiedSince, ifUnmodifiedSince, requestId, containerAcl, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        final String restype = "container";
        final String comp = "acl";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        BlobSignedIdentifierWrapper containerAclConverted = new BlobSignedIdentifierWrapper(containerAcl);
        return service
            .setAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId,
                containerAclConverted, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String containerName,
        Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        try {
            final String restype = "container";
            final String comp = "acl";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            BlobSignedIdentifierWrapper containerAclConverted = new BlobSignedIdentifierWrapper(containerAcl);
            return service.setAccessPolicySync(this.client.getUrl(), containerName, restype, comp, timeout, leaseId,
                access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId,
                containerAclConverted, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setAccessPolicy(String containerName, Integer timeout, String leaseId, PublicAccessType access,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        List<BlobSignedIdentifier> containerAcl) {
        setAccessPolicyWithResponse(containerName, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince,
            requestId, containerAcl, Context.NONE);
    }

    /**
     * sets the permissions for the specified container. The permissions indicate whether blobs in a container may be
     * accessed publicly.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param access Specifies whether data in the container may be accessed publicly and the level of access.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param containerAcl the acls for the container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setAccessPolicyNoCustomHeadersWithResponse(String containerName, Integer timeout,
        String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        try {
            final String restype = "container";
            final String comp = "acl";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            BlobSignedIdentifierWrapper containerAclConverted = new BlobSignedIdentifierWrapper(containerAcl);
            return service.setAccessPolicyNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp,
                timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                this.client.getVersion(), requestId, containerAclConverted, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRestoreHeaders, Void>> restoreWithResponseAsync(String containerName,
        Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion) {
        return FluxUtil
            .withContext(context -> restoreWithResponseAsync(containerName, timeout, requestId, deletedContainerName,
                deletedContainerVersion, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRestoreHeaders, Void>> restoreWithResponseAsync(String containerName,
        Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion,
        Context context) {
        final String restype = "container";
        final String comp = "undelete";
        final String accept = "application/xml";
        return service
            .restore(this.client.getUrl(), containerName, restype, comp, timeout, this.client.getVersion(), requestId,
                deletedContainerName, deletedContainerVersion, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String containerName, Integer timeout, String requestId, String deletedContainerName,
        String deletedContainerVersion) {
        return restoreWithResponseAsync(containerName, timeout, requestId, deletedContainerName,
            deletedContainerVersion)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String containerName, Integer timeout, String requestId, String deletedContainerName,
        String deletedContainerVersion, Context context) {
        return restoreWithResponseAsync(containerName, timeout, requestId, deletedContainerName,
            deletedContainerVersion, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String requestId, String deletedContainerName, String deletedContainerVersion) {
        return FluxUtil
            .withContext(context -> restoreNoCustomHeadersWithResponseAsync(containerName, timeout, requestId,
                deletedContainerName, deletedContainerVersion, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        final String restype = "container";
        final String comp = "undelete";
        final String accept = "application/xml";
        return service
            .restoreNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersRestoreHeaders, Void> restoreWithResponse(String containerName, Integer timeout,
        String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        try {
            final String restype = "container";
            final String comp = "undelete";
            final String accept = "application/xml";
            return service.restoreSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restore(String containerName, Integer timeout, String requestId, String deletedContainerName,
        String deletedContainerVersion) {
        restoreWithResponse(containerName, timeout, requestId, deletedContainerName, deletedContainerVersion,
            Context.NONE);
    }

    /**
     * Restores a previously-deleted container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param deletedContainerName Optional. Version 2019-12-12 and later. Specifies the name of the deleted container
     * to restore.
     * @param deletedContainerVersion Optional. Version 2019-12-12 and later. Specifies the version of the deleted
     * container to restore.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> restoreNoCustomHeadersWithResponse(String containerName, Integer timeout, String requestId,
        String deletedContainerName, String deletedContainerVersion, Context context) {
        try {
            final String restype = "container";
            final String comp = "undelete";
            final String accept = "application/xml";
            return service.restoreNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenameHeaders, Void>> renameWithResponseAsync(String containerName,
        String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId) {
        return FluxUtil
            .withContext(context -> renameWithResponseAsync(containerName, sourceContainerName, timeout, requestId,
                sourceLeaseId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenameHeaders, Void>> renameWithResponseAsync(String containerName,
        String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        final String restype = "container";
        final String comp = "rename";
        final String accept = "application/xml";
        return service
            .rename(this.client.getUrl(), containerName, restype, comp, timeout, this.client.getVersion(), requestId,
                sourceContainerName, sourceLeaseId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renameAsync(String containerName, String sourceContainerName, Integer timeout, String requestId,
        String sourceLeaseId) {
        return renameWithResponseAsync(containerName, sourceContainerName, timeout, requestId, sourceLeaseId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renameAsync(String containerName, String sourceContainerName, Integer timeout, String requestId,
        String sourceLeaseId, Context context) {
        return renameWithResponseAsync(containerName, sourceContainerName, timeout, requestId, sourceLeaseId, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String containerName, String sourceContainerName,
        Integer timeout, String requestId, String sourceLeaseId) {
        return FluxUtil
            .withContext(context -> renameNoCustomHeadersWithResponseAsync(containerName, sourceContainerName, timeout,
                requestId, sourceLeaseId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String containerName, String sourceContainerName,
        Integer timeout, String requestId, String sourceLeaseId, Context context) {
        final String restype = "container";
        final String comp = "rename";
        final String accept = "application/xml";
        return service
            .renameNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersRenameHeaders, Void> renameWithResponse(String containerName,
        String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        try {
            final String restype = "container";
            final String comp = "rename";
            final String accept = "application/xml";
            return service.renameSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void rename(String containerName, String sourceContainerName, Integer timeout, String requestId,
        String sourceLeaseId) {
        renameWithResponse(containerName, sourceContainerName, timeout, requestId, sourceLeaseId, Context.NONE);
    }

    /**
     * Renames an existing container.
     *
     * @param containerName The container name.
     * @param sourceContainerName Required. Specifies the name of the container to rename.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceLeaseId A lease ID for the source path. If specified, the source path must have an active lease and
     * the lease ID must match.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> renameNoCustomHeadersWithResponse(String containerName, String sourceContainerName,
        Integer timeout, String requestId, String sourceLeaseId, Context context) {
        try {
            final String restype = "container";
            final String comp = "rename";
            final String accept = "application/xml";
            return service.renameNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(
        String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(context -> submitBatchWithResponseAsync(containerName, contentLength, multipartContentType,
                body, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(
        String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout,
        String requestId, Context context) {
        final String restype = "container";
        final String comp = "batch";
        final String accept = "application/xml";
        return service
            .submitBatch(this.client.getUrl(), containerName, restype, comp, contentLength, multipartContentType,
                timeout, this.client.getVersion(), requestId, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType,
        Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMapMany(fluxByteBufferResponse -> fluxByteBufferResponse.getValue());
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType,
        Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        return submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMapMany(fluxByteBufferResponse -> fluxByteBufferResponse.getValue());
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength,
        String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> submitBatchNoCustomHeadersWithResponseAsync(containerName, contentLength,
                multipartContentType, body, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength,
        String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        final String restype = "container";
        final String comp = "batch";
        final String accept = "application/xml";
        return service
            .submitBatchNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, contentLength,
                multipartContentType, timeout, this.client.getVersion(), requestId, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(
        String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(context -> submitBatchWithResponseAsync(containerName, contentLength, multipartContentType,
                body, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(
        String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout,
        String requestId, Context context) {
        final String restype = "container";
        final String comp = "batch";
        final String accept = "application/xml";
        return service
            .submitBatch(this.client.getUrl(), containerName, restype, comp, contentLength, multipartContentType,
                timeout, this.client.getVersion(), requestId, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType,
        BinaryData body, Integer timeout, String requestId) {
        return submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMapMany(fluxByteBufferResponse -> fluxByteBufferResponse.getValue());
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType,
        BinaryData body, Integer timeout, String requestId, Context context) {
        return submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMapMany(fluxByteBufferResponse -> fluxByteBufferResponse.getValue());
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength,
        String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> submitBatchNoCustomHeadersWithResponseAsync(containerName, contentLength,
                multipartContentType, body, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength,
        String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        final String restype = "container";
        final String comp = "batch";
        final String accept = "application/xml";
        return service
            .submitBatchNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, contentLength,
                multipartContentType, timeout, this.client.getVersion(), requestId, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersSubmitBatchHeaders, InputStream> submitBatchWithResponse(String containerName,
        long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId,
        Context context) {
        try {
            final String restype = "container";
            final String comp = "batch";
            final String accept = "application/xml";
            return service.submitBatchSync(this.client.getUrl(), containerName, restype, comp, contentLength,
                multipartContentType, timeout, this.client.getVersion(), requestId, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public InputStream submitBatch(String containerName, long contentLength, String multipartContentType,
        BinaryData body, Integer timeout, String requestId) {
        try {
            return submitBatchWithResponse(containerName, contentLength, multipartContentType, body, timeout, requestId,
                Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Batch operation allows multiple API calls to be embedded into a single HTTP request.
     *
     * @param containerName The container name.
     * @param contentLength The length of the request.
     * @param multipartContentType Required. The value of this header must be multipart/mixed with a batch boundary.
     * Example header value: multipart/mixed; boundary=batch_&lt;GUID&gt;.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<InputStream> submitBatchNoCustomHeadersWithResponse(String containerName, long contentLength,
        String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "batch";
            final String accept = "application/xml";
            return service.submitBatchNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp,
                contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(
        String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults,
        List<FilterBlobsIncludeItem> include) {
        return FluxUtil
            .withContext(context -> filterBlobsWithResponseAsync(containerName, timeout, requestId, where, marker,
                maxresults, include, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link ResponseBase} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(
        String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults,
        List<FilterBlobsIncludeItem> include, Context context) {
        final String restype = "container";
        final String comp = "blobs";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .filterBlobs(this.client.getUrl(), containerName, restype, comp, timeout, this.client.getVersion(),
                requestId, where, marker, maxresults, includeConverted, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(String containerName, Integer timeout, String requestId,
        String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        return filterBlobsWithResponseAsync(containerName, timeout, requestId, where, marker, maxresults, include)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(String containerName, Integer timeout, String requestId,
        String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include, Context context) {
        return filterBlobsWithResponseAsync(containerName, timeout, requestId, where, marker, maxresults, include,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(String containerName,
        Integer timeout, String requestId, String where, String marker, Integer maxresults,
        List<FilterBlobsIncludeItem> include) {
        return FluxUtil
            .withContext(context -> filterBlobsNoCustomHeadersWithResponseAsync(containerName, timeout, requestId,
                where, marker, maxresults, include, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(String containerName,
        Integer timeout, String requestId, String where, String marker, Integer maxresults,
        List<FilterBlobsIncludeItem> include, Context context) {
        final String restype = "container";
        final String comp = "blobs";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .filterBlobsNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment> filterBlobsWithResponse(String containerName,
        Integer timeout, String requestId, String where, String marker, Integer maxresults,
        List<FilterBlobsIncludeItem> include, Context context) {
        try {
            final String restype = "container";
            final String comp = "blobs";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.filterBlobsSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FilterBlobSegment filterBlobs(String containerName, Integer timeout, String requestId, String where,
        String marker, Integer maxresults, List<FilterBlobsIncludeItem> include) {
        try {
            return filterBlobsWithResponse(containerName, timeout, requestId, where, marker, maxresults, include,
                Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Filter Blobs operation enables callers to list blobs in a container whose tags match a given search
     * expression. Filter blobs searches within the given container.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param where Filters the results to return only to return only blobs whose tags match the specified expression.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a Filter Blobs API call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FilterBlobSegment> filterBlobsNoCustomHeadersWithResponse(String containerName, Integer timeout,
        String requestId, String where, String marker, Integer maxresults, List<FilterBlobsIncludeItem> include,
        Context context) {
        try {
            final String restype = "container";
            final String comp = "blobs";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.filterBlobsNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, where, marker, maxresults, includeConverted, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String containerName,
        Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> acquireLeaseWithResponseAsync(containerName, timeout, duration, proposedLeaseId,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String containerName,
        Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "acquire";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .acquireLease(this.client.getUrl(), containerName, comp, restype, action, timeout, duration,
                proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return acquireLeaseWithResponseAsync(containerName, timeout, duration, proposedLeaseId, ifModifiedSince,
            ifUnmodifiedSince, requestId)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return acquireLeaseWithResponseAsync(containerName, timeout, duration, proposedLeaseId, ifModifiedSince,
            ifUnmodifiedSince, requestId, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> acquireLeaseNoCustomHeadersWithResponseAsync(containerName, timeout, duration,
                proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "acquire";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .acquireLeaseNoCustomHeaders(this.client.getUrl(), containerName, comp, restype, action, timeout, duration,
                proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersAcquireLeaseHeaders, Void> acquireLeaseWithResponse(String containerName,
        Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "acquire";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.acquireLeaseSync(this.client.getUrl(), containerName, comp, restype, action, timeout,
                duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void acquireLease(String containerName, Integer timeout, Integer duration, String proposedLeaseId,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        acquireLeaseWithResponse(containerName, timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince,
            requestId, Context.NONE);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param duration Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never
     * expires. A non-infinite lease can be between 15 and 60 seconds. A lease duration cannot be changed using renew or
     * change.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> acquireLeaseNoCustomHeadersWithResponse(String containerName, Integer timeout,
        Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "acquire";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.acquireLeaseNoCustomHeadersSync(this.client.getUrl(), containerName, comp, restype, action,
                timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String containerName,
        String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> releaseLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince,
                ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String containerName,
        String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "release";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service.releaseLease(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
            ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return releaseLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return releaseLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> releaseLeaseNoCustomHeadersWithResponseAsync(containerName, leaseId, timeout,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "release";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .releaseLeaseNoCustomHeaders(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersReleaseLeaseHeaders, Void> releaseLeaseWithResponse(String containerName,
        String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "release";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.releaseLeaseSync(this.client.getUrl(), containerName, comp, restype, action, timeout,
                leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId,
                accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void releaseLease(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        releaseLeaseWithResponse(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId,
            Context.NONE);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> releaseLeaseNoCustomHeadersWithResponse(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "release";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.releaseLeaseNoCustomHeadersSync(this.client.getUrl(), containerName, comp, restype, action,
                timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String containerName,
        String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> renewLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince,
                ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String containerName,
        String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "renew";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service.renewLease(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
            ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return renewLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return renewLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> renewLeaseNoCustomHeadersWithResponseAsync(containerName, leaseId, timeout,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "renew";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .renewLeaseNoCustomHeaders(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersRenewLeaseHeaders, Void> renewLeaseWithResponse(String containerName, String leaseId,
        Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "renew";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.renewLeaseSync(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void renewLease(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        renewLeaseWithResponse(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId,
            Context.NONE);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> renewLeaseNoCustomHeadersWithResponse(String containerName, String leaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "renew";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.renewLeaseNoCustomHeadersSync(this.client.getUrl(), containerName, comp, restype, action,
                timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String containerName,
        Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> breakLeaseWithResponseAsync(containerName, timeout, breakPeriod, ifModifiedSince,
                ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String containerName,
        Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "break";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service.breakLease(this.client.getUrl(), containerName, comp, restype, action, timeout, breakPeriod,
            ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String containerName, Integer timeout, Integer breakPeriod,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return breakLeaseWithResponseAsync(containerName, timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String containerName, Integer timeout, Integer breakPeriod,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return breakLeaseWithResponseAsync(containerName, timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> breakLeaseNoCustomHeadersWithResponseAsync(containerName, timeout, breakPeriod,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "break";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .breakLeaseNoCustomHeaders(this.client.getUrl(), containerName, comp, restype, action, timeout, breakPeriod,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersBreakLeaseHeaders, Void> breakLeaseWithResponse(String containerName, Integer timeout,
        Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "break";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.breakLeaseSync(this.client.getUrl(), containerName, comp, restype, action, timeout,
                breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId,
                accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void breakLease(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        breakLeaseWithResponse(containerName, timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId,
            Context.NONE);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param breakPeriod For a break operation, proposed duration the lease should continue before it is broken, in
     * seconds, between 0 and 60. This break period is only used if it is shorter than the time remaining on the lease.
     * If longer, the time remaining on the lease is used. A new lease will not be available before the break period has
     * expired, but the lease may be held for longer than the break period. If this header does not appear with a break
     * operation, a fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
     * immediately.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> breakLeaseNoCustomHeadersWithResponse(String containerName, Integer timeout,
        Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId,
        Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "break";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.breakLeaseNoCustomHeadersSync(this.client.getUrl(), containerName, comp, restype, action,
                timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String containerName,
        String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId) {
        return FluxUtil
            .withContext(context -> changeLeaseWithResponseAsync(containerName, leaseId, proposedLeaseId, timeout,
                ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String containerName,
        String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "change";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .changeLease(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId, proposedLeaseId,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return changeLeaseWithResponseAsync(containerName, leaseId, proposedLeaseId, timeout, ifModifiedSince,
            ifUnmodifiedSince, requestId)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return changeLeaseWithResponseAsync(containerName, leaseId, proposedLeaseId, timeout, ifModifiedSince,
            ifUnmodifiedSince, requestId, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId) {
        return FluxUtil
            .withContext(context -> changeLeaseNoCustomHeadersWithResponseAsync(containerName, leaseId, proposedLeaseId,
                timeout, ifModifiedSince, ifUnmodifiedSince, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId,
        String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        final String comp = "lease";
        final String restype = "container";
        final String action = "change";
        final String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return service
            .changeLeaseNoCustomHeaders(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
                proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersChangeLeaseHeaders, Void> changeLeaseWithResponse(String containerName,
        String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "change";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.changeLeaseSync(this.client.getUrl(), containerName, comp, restype, action, timeout, leaseId,
                proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void changeLease(String containerName, String leaseId, String proposedLeaseId, Integer timeout,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        changeLeaseWithResponse(containerName, leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince,
            requestId, Context.NONE);
    }

    /**
     * [Update] establishes and manages a lock on a container for delete operations. The lock duration can be 15 to 60
     * seconds, or can be infinite.
     *
     * @param containerName The container name.
     * @param leaseId Specifies the current lease ID on the resource.
     * @param proposedLeaseId Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request)
     * if the proposed lease ID is not in the correct format. See Guid Constructor (String) for a list of valid GUID
     * string formats.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> changeLeaseNoCustomHeadersWithResponse(String containerName, String leaseId,
        String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince,
        String requestId, Context context) {
        try {
            final String comp = "lease";
            final String restype = "container";
            final String action = "change";
            final String accept = "application/xml";
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            return service.changeLeaseNoCustomHeadersSync(this.client.getUrl(), containerName, comp, restype, action,
                timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>>
        listBlobFlatSegmentWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults,
            List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> listBlobFlatSegmentWithResponseAsync(containerName, prefix, marker, maxresults,
                include, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>>
        listBlobFlatSegmentWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults,
            List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        final String restype = "container";
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listBlobFlatSegment(this.client.getUrl(), containerName, restype, comp, prefix, marker, maxresults,
                includeConverted, timeout, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(String containerName, String prefix,
        String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return listBlobFlatSegmentWithResponseAsync(containerName, prefix, marker, maxresults, include, timeout,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(String containerName, String prefix,
        String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId,
        Context context) {
        return listBlobFlatSegmentWithResponseAsync(containerName, prefix, marker, maxresults, include, timeout,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeadersWithResponseAsync(
        String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include,
        Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> listBlobFlatSegmentNoCustomHeadersWithResponseAsync(containerName, prefix, marker,
                maxresults, include, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeadersWithResponseAsync(
        String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include,
        Integer timeout, String requestId, Context context) {
        final String restype = "container";
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listBlobFlatSegmentNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, prefix, marker,
                maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>
        listBlobFlatSegmentWithResponse(String containerName, String prefix, String marker, Integer maxresults,
            List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.listBlobFlatSegmentSync(this.client.getUrl(), containerName, restype, comp, prefix, marker,
                maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ListBlobsFlatSegmentResponse listBlobFlatSegment(String containerName, String prefix, String marker,
        Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        try {
            return listBlobFlatSegmentWithResponse(containerName, prefix, marker, maxresults, include, timeout,
                requestId, Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ListBlobsFlatSegmentResponse> listBlobFlatSegmentNoCustomHeadersWithResponse(String containerName,
        String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout,
        String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.listBlobFlatSegmentNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp,
                prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>>
        listBlobHierarchySegmentWithResponseAsync(String containerName, String delimiter, String prefix, String marker,
            Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> listBlobHierarchySegmentWithResponseAsync(containerName, delimiter, prefix, marker,
                maxresults, include, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>>
        listBlobHierarchySegmentWithResponseAsync(String containerName, String delimiter, String prefix, String marker,
            Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId,
            Context context) {
        final String restype = "container";
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listBlobHierarchySegment(this.client.getUrl(), containerName, restype, comp, prefix, delimiter, marker,
                maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String containerName, String delimiter,
        String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout,
        String requestId) {
        return listBlobHierarchySegmentWithResponseAsync(containerName, delimiter, prefix, marker, maxresults, include,
            timeout, requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String containerName, String delimiter,
        String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout,
        String requestId, Context context) {
        return listBlobHierarchySegmentWithResponseAsync(containerName, delimiter, prefix, marker, maxresults, include,
            timeout, requestId, context)
                .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(
        String containerName, String delimiter, String prefix, String marker, Integer maxresults,
        List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(containerName, delimiter,
                prefix, marker, maxresults, include, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(
        String containerName, String delimiter, String prefix, String marker, Integer maxresults,
        List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        final String restype = "container";
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted = (include == null)
            ? null
            : include.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service
            .listBlobHierarchySegmentNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, prefix,
                delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>
        listBlobHierarchySegmentWithResponse(String containerName, String delimiter, String prefix, String marker,
            Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId,
            Context context) {
        try {
            final String restype = "container";
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.listBlobHierarchySegmentSync(this.client.getUrl(), containerName, restype, comp, prefix,
                delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ListBlobsHierarchySegmentResponse listBlobHierarchySegment(String containerName, String delimiter,
        String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout,
        String requestId) {
        try {
            return listBlobHierarchySegmentWithResponse(containerName, delimiter, prefix, marker, maxresults, include,
                timeout, requestId, Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * [Update] The List Blobs operation returns a list of the blobs under the specified container.
     *
     * @param containerName The container name.
     * @param delimiter When the request includes this parameter, the operation returns a BlobPrefix element in the
     * response body that acts as a placeholder for all blobs whose names begin with the same substring up to the
     * appearance of the delimiter character. The delimiter may be a single character or a string.
     * @param prefix Filters the results to return only containers whose name begins with the specified prefix.
     * @param marker A string value that identifies the portion of the list of containers to be returned with the next
     * listing operation. The operation returns the NextMarker value within the response body if the listing operation
     * did not return all containers remaining to be listed with the current page. The NextMarker value can be used as
     * the value for the marker parameter in a subsequent call to request the next page of list items. The marker value
     * is opaque to the client.
     * @param maxresults Specifies the maximum number of containers to return. If the request does not specify
     * maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the
     * listing operation crosses a partition boundary, then the service will return a continuation token for retrieving
     * the remainder of the results. For this reason, it is possible that the service will return fewer results than
     * specified by maxresults, or than the default of 5000.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of blobs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentNoCustomHeadersWithResponse(
        String containerName, String delimiter, String prefix, String marker, Integer maxresults,
        List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        try {
            final String restype = "container";
            final String comp = "list";
            final String accept = "application/xml";
            String includeConverted = (include == null)
                ? null
                : include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
            return service.listBlobHierarchySegmentNoCustomHeadersSync(this.client.getUrl(), containerName, restype,
                comp, prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(),
                requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>>
        getAccountInfoWithResponseAsync(String containerName, Integer timeout, String requestId) {
        return FluxUtil
            .withContext(context -> getAccountInfoWithResponseAsync(containerName, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>>
        getAccountInfoWithResponseAsync(String containerName, Integer timeout, String requestId, Context context) {
        final String restype = "account";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .getAccountInfo(this.client.getUrl(), containerName, restype, comp, timeout, this.client.getVersion(),
                requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(String containerName, Integer timeout, String requestId) {
        return getAccountInfoWithResponseAsync(containerName, timeout, requestId)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(String containerName, Integer timeout, String requestId, Context context) {
        return getAccountInfoWithResponseAsync(containerName, timeout, requestId, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String requestId) {
        return FluxUtil
            .withContext(
                context -> getAccountInfoNoCustomHeadersWithResponseAsync(containerName, timeout, requestId, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(String containerName, Integer timeout,
        String requestId, Context context) {
        final String restype = "account";
        final String comp = "properties";
        final String accept = "application/xml";
        return service
            .getAccountInfoNoCustomHeaders(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainersGetAccountInfoHeaders, Void> getAccountInfoWithResponse(String containerName,
        Integer timeout, String requestId, Context context) {
        try {
            final String restype = "account";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.getAccountInfoSync(this.client.getUrl(), containerName, restype, comp, timeout,
                this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void getAccountInfo(String containerName, Integer timeout, String requestId) {
        getAccountInfoWithResponse(containerName, timeout, requestId, Context.NONE);
    }

    /**
     * Returns the sku name and account kind.
     *
     * @param containerName The container name.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> getAccountInfoNoCustomHeadersWithResponse(String containerName, Integer timeout,
        String requestId, Context context) {
        try {
            final String restype = "account";
            final String comp = "properties";
            final String accept = "application/xml";
            return service.getAccountInfoNoCustomHeadersSync(this.client.getUrl(), containerName, restype, comp,
                timeout, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }
}
