// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The result of a Filter Blobs API call.
 */
@Fluent
public final class FilterBlobSegment implements XmlSerializable<FilterBlobSegment> {
    /*
     * The ServiceEndpoint property.
     */
    private String serviceEndpoint;

    /*
     * The Where property.
     */
    private String where;

    /*
     * The Blobs property.
     */
    private List<FilterBlobItem> blobs;

    /*
     * The NextMarker property.
     */
    private String nextMarker;

    /**
     * Creates an instance of FilterBlobSegment class.
     */
    public FilterBlobSegment() {
    }

    /**
     * Get the serviceEndpoint property: The ServiceEndpoint property.
     * 
     * @return the serviceEndpoint value.
     */
    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint property: The ServiceEndpoint property.
     * 
     * @param serviceEndpoint the serviceEndpoint value to set.
     * @return the FilterBlobSegment object itself.
     */
    public FilterBlobSegment setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the where property: The Where property.
     * 
     * @return the where value.
     */
    public String getWhere() {
        return this.where;
    }

    /**
     * Set the where property: The Where property.
     * 
     * @param where the where value to set.
     * @return the FilterBlobSegment object itself.
     */
    public FilterBlobSegment setWhere(String where) {
        this.where = where;
        return this;
    }

    /**
     * Get the blobs property: The Blobs property.
     * 
     * @return the blobs value.
     */
    public List<FilterBlobItem> getBlobs() {
        if (this.blobs == null) {
            this.blobs = new ArrayList<>();
        }
        return this.blobs;
    }

    /**
     * Set the blobs property: The Blobs property.
     * 
     * @param blobs the blobs value to set.
     * @return the FilterBlobSegment object itself.
     */
    public FilterBlobSegment setBlobs(List<FilterBlobItem> blobs) {
        this.blobs = blobs;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     * 
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     * 
     * @param nextMarker the nextMarker value to set.
     * @return the FilterBlobSegment object itself.
     */
    public FilterBlobSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringElement("Where", this.where);
        if (this.blobs != null) {
            xmlWriter.writeStartElement("Blobs");
            for (FilterBlobItem element : this.blobs) {
                xmlWriter.writeXml(element, "Blob");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FilterBlobSegment from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of FilterBlobSegment if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the FilterBlobSegment.
     */
    public static FilterBlobSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FilterBlobSegment from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FilterBlobSegment if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the FilterBlobSegment.
     */
    public static FilterBlobSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "EnumerationResults" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            FilterBlobSegment deserializedFilterBlobSegment = new FilterBlobSegment();
            deserializedFilterBlobSegment.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Where".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobSegment.where = reader.getStringElement();
                } else if ("Blobs".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Blob".equals(elementName.getLocalPart())) {
                            if (deserializedFilterBlobSegment.blobs == null) {
                                deserializedFilterBlobSegment.blobs = new ArrayList<>();
                            }
                            deserializedFilterBlobSegment.blobs.add(FilterBlobItem.fromXml(reader, "Blob"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobSegment.nextMarker = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedFilterBlobSegment;
        });
    }
}
